/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.command;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.chat.EnumChatFormat;
import me.neznamy.tab.api.chat.IChatBaseComponent;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.command.AnnounceCommand;
import me.neznamy.tab.shared.command.BossBarCommand;
import me.neznamy.tab.shared.command.CpuCommand;
import me.neznamy.tab.shared.command.DebugCommand;
import me.neznamy.tab.shared.command.GroupCommand;
import me.neznamy.tab.shared.command.NTPreviewCommand;
import me.neznamy.tab.shared.command.ParseCommand;
import me.neznamy.tab.shared.command.PlayerCommand;
import me.neznamy.tab.shared.command.PlayerUUIDCommand;
import me.neznamy.tab.shared.command.ReloadCommand;
import me.neznamy.tab.shared.command.ScoreboardCommand;
import me.neznamy.tab.shared.command.SendCommand;
import me.neznamy.tab.shared.command.SetCollisionCommand;
import me.neznamy.tab.shared.command.SubCommand;
import me.neznamy.tab.shared.command.WidthCommand;

public class TabCommand
extends SubCommand {
    private final TAB tab;

    public TabCommand(TAB tab) {
        super("tab", null);
        this.tab = tab;
        this.registerSubCommand(new AnnounceCommand());
        this.registerSubCommand(new BossBarCommand());
        this.registerSubCommand(new CpuCommand());
        this.registerSubCommand(new DebugCommand());
        this.registerSubCommand(new GroupCommand());
        this.registerSubCommand(new NTPreviewCommand());
        this.registerSubCommand(new ParseCommand());
        this.registerSubCommand(new PlayerCommand());
        this.registerSubCommand(new PlayerUUIDCommand());
        this.registerSubCommand(new ReloadCommand());
        this.registerSubCommand(new SendCommand());
        this.registerSubCommand(new SetCollisionCommand());
        this.registerSubCommand(new ScoreboardCommand());
        this.registerSubCommand(new WidthCommand());
        ArrayList properties = Lists.newArrayList((Object[])new String[]{"tabprefix", "tabsuffix", "tagprefix", "tagsuffix", "customtabname", "abovename", "belowname", "customtagname"});
        for (Object line : ((DebugCommand)this.getSubcommands().get("debug")).getExtraLines()) {
            properties.add(line.toString());
        }
        SubCommand.setAllProperties(properties.toArray(new String[0]));
    }

    @Override
    public void execute(TabPlayer sender, String[] args) {
        if (args.length > 0) {
            String arg0 = args[0];
            SubCommand command = this.getSubcommands().get(arg0.toLowerCase());
            if (command != null) {
                if (command.hasPermission(sender)) {
                    command.execute(sender, Arrays.copyOfRange(args, 1, args.length));
                } else {
                    this.sendMessage(sender, this.getMessages().getNoPermission());
                }
            } else {
                this.help(sender);
            }
        } else {
            this.help(sender);
        }
    }

    private void help(TabPlayer sender) {
        if (this.hasPermission(sender, "tab.admin")) {
            if (sender != null) {
                IChatBaseComponent component = new IChatBaseComponent(EnumChatFormat.color("&3TAB v") + "3.0.2");
                component.getModifier().onHoverShowText(new IChatBaseComponent(EnumChatFormat.color("&aClick to visit plugin's page")));
                component.getModifier().onClickOpenUrl("https://www.mc-market.org/resources/14009/");
                component.addExtra(new IChatBaseComponent(EnumChatFormat.color("&0 by _NEZNAMY_")));
                sender.sendMessage(component);
            } else {
                this.tab.getPlatform().sendConsoleMessage("&3TAB v3.0.2", true);
            }
            for (String message : this.getMessages().getHelpMenu()) {
                if (this.tab.getPlatform().isProxy()) {
                    message = message.replace("/tab", "/btab");
                }
                this.sendMessage(sender, message);
            }
        }
    }

    @Override
    public List<String> complete(TabPlayer sender, String[] arguments) {
        if (!this.hasPermission(sender, "tab.tabcomplete")) {
            return new ArrayList<String>();
        }
        return super.complete(sender, arguments);
    }
}

