/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.command.level2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.bossbar.BossBar;
import me.neznamy.tab.api.bossbar.BossBarManager;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.command.SubCommand;
import me.neznamy.tab.shared.features.bossbar.BossBarLine;

public class SendBarCommand
extends SubCommand {
    public SendBarCommand() {
        super("bar", "tab.send.bar");
    }

    @Override
    public void execute(TabPlayer sender, String[] args) {
        int duration;
        BossBarManager feature = (BossBarManager)((Object)TAB.getInstance().getFeatureManager().getFeature("BossBar"));
        if (feature == null) {
            this.sendMessage(sender, this.getMessages().getBossBarNotEnabled());
            return;
        }
        if (args.length != 3) {
            this.sendMessage(sender, this.getMessages().getSendBarCommandUsage());
            return;
        }
        TabPlayer target = TAB.getInstance().getPlayer(args[0]);
        if (target == null) {
            this.sendMessage(sender, this.getMessages().getPlayerNotFound(args[0]));
            return;
        }
        String barName = args[1];
        try {
            duration = Integer.parseInt(args[2]);
        }
        catch (NumberFormatException e) {
            this.sendMessage(sender, this.getMessages().getInvalidNumber(args[1]));
            return;
        }
        BossBar bar = feature.getBossBar(barName);
        if (bar == null) {
            this.sendMessage(sender, this.getMessages().getBossBarNotFound(barName));
            return;
        }
        if (!((BossBarLine)bar).isAnnouncementOnly()) {
            this.sendMessage(sender, this.getMessages().getBossBarNotMarkedAsAnnouncement());
            return;
        }
        feature.sendBossBarTemporarily(target, bar.getName(), duration);
        this.sendMessage(sender, this.getMessages().getBossBarSendSuccess(target.getName(), bar.getName(), duration));
    }

    @Override
    public List<String> complete(TabPlayer sender, String[] arguments) {
        BossBarManager b = (BossBarManager)((Object)TAB.getInstance().getFeatureManager().getFeature("BossBar"));
        if (b == null) {
            return new ArrayList<String>();
        }
        if (arguments.length == 1) {
            return this.getOnlinePlayers(arguments[0]);
        }
        if (arguments.length == 2) {
            return this.getStartingArgument(b.getRegisteredBossBars().keySet(), arguments[1]);
        }
        if (arguments.length == 3 && b.getBossBar(arguments[1]) != null) {
            return this.getStartingArgument(Arrays.asList("5", "10", "30", "60", "120"), arguments[2]);
        }
        return new ArrayList<String>();
    }
}

