/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.config;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import me.neznamy.tab.api.PropertyConfiguration;
import me.neznamy.tab.api.config.ConfigurationFile;
import me.neznamy.tab.api.config.YamlConfigurationFile;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.config.Converter;
import me.neznamy.tab.shared.config.MessageFile;
import me.neznamy.tab.shared.config.MySQL;
import me.neznamy.tab.shared.config.file.YamlPropertyConfigurationFile;
import me.neznamy.tab.shared.config.mysql.MySQLGroupConfiguration;
import me.neznamy.tab.shared.config.mysql.MySQLUserConfiguration;
import org.yaml.snakeyaml.error.YAMLException;

public class Configs {
    private final TAB tab;
    private final Converter converter = new Converter();
    private ConfigurationFile config;
    private boolean bukkitPermissions;
    private boolean unregisterBeforeRegister;
    private boolean armorStandsAlwaysVisible;
    private boolean removeGhostPlayers;
    private boolean pipelineInjection;
    private ConfigurationFile animation;
    private MessageFile messages;
    private String reloadFailed = "&4Failed to reload, file %file% has broken syntax. Check console for more info.";
    private ConfigurationFile playerdata;
    private ConfigurationFile layout;
    private PropertyConfiguration groupFile;
    private PropertyConfiguration userFile;
    private MySQL mysql;

    public Configs(TAB tab) {
        this.tab = tab;
    }

    public void loadFiles() throws YAMLException, IOException {
        ClassLoader loader = Configs.class.getClassLoader();
        this.loadConfig();
        this.animation = new YamlConfigurationFile(loader.getResourceAsStream("animations.yml"), new File(this.tab.getPlatform().getDataFolder(), "animations.yml"));
        this.converter.convertAnimationFile(this.animation);
        this.messages = new MessageFile();
        this.layout = new YamlConfigurationFile(loader.getResourceAsStream("layout.yml"), new File(this.tab.getPlatform().getDataFolder(), "layout.yml"));
        this.reloadFailed = this.messages.getReloadFailBrokenFile();
    }

    public void loadConfig() throws YAMLException, IOException {
        this.config = new YamlConfigurationFile(Configs.class.getClassLoader().getResourceAsStream(this.tab.getPlatform().getConfigName()), new File(this.tab.getPlatform().getDataFolder(), "config.yml"));
        this.converter.convertToV3(this.config);
        this.converter.removeOldOptions(this.config);
        this.tab.setDebugMode(this.getConfig().getBoolean("debug", false));
        if (this.tab.getPlatform().isProxy()) {
            this.bukkitPermissions = this.getConfig().getBoolean("use-bukkit-permissions-manager", false);
        } else {
            this.unregisterBeforeRegister = (Boolean)this.getSecretOption("unregister-before-register", true);
            this.armorStandsAlwaysVisible = (Boolean)this.getSecretOption("scoreboard-teams.unlimited-nametag-mode.always-visible", false);
        }
        this.removeGhostPlayers = (Boolean)this.getSecretOption("remove-ghost-players", false);
        boolean bl = this.pipelineInjection = (Boolean)this.getSecretOption("pipeline-injection", true) != false && this.tab.getServerVersion().getMinorVersion() >= 8;
        if (this.config.getBoolean("mysql.enabled", false)) {
            try {
                this.mysql = new MySQL(this.config.getString("mysql.host", "127.0.0.1"), this.config.getInt("mysql.port", 3306), this.config.getString("mysql.database", "tab"), this.config.getString("mysql.username", "user"), this.config.getString("mysql.password", "password"));
                this.groupFile = new MySQLGroupConfiguration(this.mysql);
                this.userFile = new MySQLUserConfiguration(this.mysql);
                return;
            }
            catch (SQLException e) {
                TAB.getInstance().getErrorManager().criticalError("Failed to connect to MySQL", e);
            }
        }
        this.groupFile = new YamlPropertyConfigurationFile(Configs.class.getClassLoader().getResourceAsStream("groups.yml"), new File(this.tab.getPlatform().getDataFolder(), "groups.yml"));
        this.userFile = new YamlPropertyConfigurationFile(Configs.class.getClassLoader().getResourceAsStream("users.yml"), new File(this.tab.getPlatform().getDataFolder(), "users.yml"));
    }

    private Object getSecretOption(String path, Object defaultValue) {
        if (this.getConfig() == null) {
            return defaultValue;
        }
        Object value = this.getConfig().getObject(path);
        return value == null ? defaultValue : value;
    }

    public boolean isUnregisterBeforeRegister() {
        return this.unregisterBeforeRegister;
    }

    public MessageFile getMessages() {
        return this.messages;
    }

    public ConfigurationFile getConfig() {
        return this.config;
    }

    public boolean isRemoveGhostPlayers() {
        return this.removeGhostPlayers;
    }

    public ConfigurationFile getLayout() {
        return this.layout;
    }

    public ConfigurationFile getAnimationFile() {
        return this.animation;
    }

    public boolean isBukkitPermissions() {
        return this.bukkitPermissions;
    }

    public boolean isPipelineInjection() {
        return this.pipelineInjection;
    }

    public boolean isArmorStandsAlwaysVisible() {
        return this.armorStandsAlwaysVisible;
    }

    public String getReloadFailedMessage() {
        return this.reloadFailed;
    }

    public ConfigurationFile getPlayerDataFile() {
        if (this.playerdata == null) {
            File file = new File(this.tab.getPlatform().getDataFolder(), "playerdata.yml");
            try {
                if (file.exists() || file.createNewFile()) {
                    this.playerdata = new YamlConfigurationFile(null, file);
                }
            }
            catch (IOException e) {
                this.tab.getErrorManager().criticalError("Failed to load playerdata.yml", e);
            }
        }
        return this.playerdata;
    }

    public PropertyConfiguration getGroups() {
        return this.groupFile;
    }

    public PropertyConfiguration getUsers() {
        return this.userFile;
    }

    public MySQL getMysql() {
        return this.mysql;
    }

    public String getGroup(List<Object> serverGroups, String element) {
        if (serverGroups.isEmpty() || element == null) {
            return element;
        }
        for (Object worldGroup : serverGroups) {
            for (String definedWorld : worldGroup.toString().split(";")) {
                if (!(definedWorld.endsWith("*") ? element.toLowerCase().startsWith(definedWorld.substring(0, definedWorld.length() - 1).toLowerCase()) : element.equalsIgnoreCase(definedWorld))) continue;
                return worldGroup.toString();
            }
        }
        return element;
    }
}

