/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.config;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.neznamy.tab.api.config.ConfigurationFile;
import me.neznamy.tab.api.config.YamlConfigurationFile;
import me.neznamy.tab.shared.TAB;

public class Converter {
    public void convertAnimationFile(ConfigurationFile animations) {
        if (animations.getValues().size() == 1 && animations.getValues().containsKey("animations")) {
            animations.setValues(animations.getConfigurationSection("animations"));
            animations.save();
            TAB.getInstance().getPlatform().sendConsoleMessage("&2[TAB] Converted animations.yml to new format.", true);
        }
    }

    public void convertToV3(ConfigurationFile currentConfig) throws IOException {
        if (currentConfig.hasConfigOption("mysql")) {
            return;
        }
        TAB.getInstance().sendConsoleMessage("&e[TAB] --------------------------------------------------------------", true);
        TAB.getInstance().sendConsoleMessage("&e[TAB] Performing configuration conversion from 2.9.2 to 3.0.0", true);
        TAB.getInstance().sendConsoleMessage("&e[TAB] Please note that this may not be 100% accurate", true);
        TAB.getInstance().sendConsoleMessage("&e[TAB] Review your configuration and verify everything is as you want it to be", true);
        TAB.getInstance().sendConsoleMessage("&e[TAB] --------------------------------------------------------------", true);
        File folder = TAB.getInstance().getPlatform().getDataFolder();
        this.moveOldFiles();
        Files.createFile(new File(folder, "groups.yml").toPath(), new FileAttribute[0]);
        Files.createFile(new File(folder, "users.yml").toPath(), new FileAttribute[0]);
        Files.createFile(new File(folder, "config.yml").toPath(), new FileAttribute[0]);
        YamlConfigurationFile groups = new YamlConfigurationFile(null, new File(folder, "groups.yml"));
        YamlConfigurationFile users = new YamlConfigurationFile(null, new File(folder, "users.yml"));
        File oldConfigsFolder = new File(folder, "old_configs");
        Files.copy(new File(oldConfigsFolder, "animations.yml").toPath(), new File(folder, "animations.yml").toPath(), new CopyOption[0]);
        File premiumFile = new File(oldConfigsFolder, "premiumconfig.yml");
        YamlConfigurationFile premiumConfig = premiumFile.exists() ? new YamlConfigurationFile(null, premiumFile) : null;
        File bossBarFile = new File(oldConfigsFolder, "bossbar.yml");
        if (!bossBarFile.exists()) {
            throw new IllegalStateException("Failed to convert configuration to v3: File bossbar.yml does not exist");
        }
        YamlConfigurationFile bossBar = new YamlConfigurationFile(null, bossBarFile);
        YamlConfigurationFile oldConfig = new YamlConfigurationFile(null, new File(oldConfigsFolder, "config.yml"));
        YamlConfigurationFile newConfig = new YamlConfigurationFile(null, new File(folder, "config.yml"));
        this.convertHeaderFooter(oldConfig, newConfig);
        this.convertTabListFormatting(oldConfig, newConfig, premiumConfig);
        this.convertTeamOptions(oldConfig, newConfig, premiumConfig);
        this.convertYellowNumber(oldConfig, newConfig);
        this.convertBelowName(oldConfig, newConfig);
        this.convertBossBar(bossBar, oldConfig, newConfig);
        if (premiumConfig != null) {
            this.convertScoreboard(newConfig, premiumConfig);
        } else {
            this.createDefaultScoreboard(newConfig);
        }
        this.convertOtherOptions(oldConfig, newConfig, premiumConfig);
        this.convertGroupsAndUsers(oldConfig, groups, users);
        currentConfig.setValues(newConfig.getValues());
    }

    private void moveOldFiles() throws IOException {
        File folder = TAB.getInstance().getPlatform().getDataFolder();
        File oldFolder = new File(folder, "old_configs");
        if (!oldFolder.exists() && !oldFolder.mkdirs()) {
            throw new RuntimeException("Failed to convert configuration to v3: Failed to create old_configs folder");
        }
        File[] files = folder.listFiles();
        if (files == null) {
            throw new IllegalStateException("Failed to convert configuration to v3: old_configs is not a folder");
        }
        for (File file : files) {
            if (!file.isFile()) continue;
            Files.move(file.toPath(), new File(folder.getPath() + File.separator + "old_configs" + File.separator + file.getName()).toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private void convertTeamOptions(ConfigurationFile oldConfig, ConfigurationFile newConfig, ConfigurationFile premiumConfig) {
        String sortingPlaceholder;
        String sortingType;
        newConfig.set("scoreboard-teams.enabled", oldConfig.getBoolean("change-nametag-prefix-suffix", true));
        newConfig.set("scoreboard-teams.invisible-nametags", oldConfig.getBoolean("invisible-nametags", false));
        newConfig.set("scoreboard-teams.anti-override", oldConfig.getBoolean("anti-override.scoreboard-teams", true));
        newConfig.set("scoreboard-teams.enable-collision", oldConfig.getBoolean("enable-collision", true));
        newConfig.set("scoreboard-teams.disable-in-worlds", oldConfig.getStringList("disable-features-in-worlds.nametag", Collections.singletonList("disabledworld")));
        if (TAB.getInstance().getPlatform().isProxy()) {
            newConfig.set("scoreboard-teams.disable-in-servers", oldConfig.getStringList("disable-features-in-servers.nametag", Collections.singletonList("disabledserver")));
        } else {
            newConfig.set("scoreboard-teams.unlimited-nametag-mode.enabled", oldConfig.getBoolean("unlimited-nametag-prefix-suffix-mode.enabled", false));
            newConfig.set("scoreboard-teams.unlimited-nametag-mode.use-marker-tag-for-1-8-x-clients", oldConfig.getBoolean("unlimited-nametag-prefix-suffix-mode.use-marker-tag-for-1-8-x-clients", false));
            newConfig.set("scoreboard-teams.unlimited-nametag-mode.disable-on-boats", oldConfig.getBoolean("unlimited-nametag-prefix-suffix-mode.disable-on-boats", true));
            newConfig.set("scoreboard-teams.unlimited-nametag-mode.space-between-lines", oldConfig.getBoolean("unlimited-nametag-prefix-suffix-mode.space-between-lines", true));
            newConfig.set("scoreboard-teams.unlimited-nametag-mode.disable-in-worlds", oldConfig.getStringList("disable-features-in-worlds.unlimited-nametags", Collections.singletonList("disabledworld")));
        }
        List<Object> placeholderOrder = new ArrayList();
        if (premiumConfig != null) {
            newConfig.set("scoreboard-teams.case-sensitive-sorting", premiumConfig.getBoolean("case-sensitive-sorting", true));
            newConfig.set("scoreboard-teams.unlimited-nametag-mode.dynamic-lines", premiumConfig.getStringList("unlimited-nametag-mode-dynamic-lines", Arrays.asList("abovename", "nametag", "belowname", "another")));
            newConfig.set("scoreboard-teams.unlimited-nametag-mode.static-lines", premiumConfig.getConfigurationSection("unlimited-nametag-mode-static-lines"));
            sortingType = premiumConfig.getString("sorting-type", "GROUPS");
            sortingPlaceholder = premiumConfig.getString("sorting-placeholder", "%some_level_maybe?%");
            placeholderOrder = premiumConfig.getStringList("placeholder-order", Arrays.asList("value1", "value2"));
        } else {
            newConfig.set("scoreboard-teams.case-sensitive-sorting", true);
            newConfig.set("scoreboard-teams.unlimited-nametag-mode.dynamic-lines", Arrays.asList("abovename", "nametag", "belowname", "another"));
            newConfig.set("scoreboard-teams.unlimited-nametag-mode.static-lines", new HashMap<String, Object>(){
                {
                    this.put("myCustomLine", 0.66);
                }
            });
            sortingType = oldConfig.getBoolean("sort-players-by-permissions", false) ? "GROUP_PERMISSIONS" : "GROUPS";
            sortingPlaceholder = "";
        }
        ArrayList<String> sortingTypes = new ArrayList<String>();
        for (String type : sortingType.split("_THEN_")) {
            if (type.equalsIgnoreCase("GROUPS") || type.equalsIgnoreCase("GROUP_PERMISSIONS")) {
                List<String> sortingList = oldConfig.getStringList("group-sorting-priority-list", Arrays.asList("owner", "admin", "mod", "helper", "builder", "premium", "player", "default"));
                StringBuilder groups = new StringBuilder(("GROUP_PERMISSIONS".equals(type) ? "PERMISSIONS" : "GROUPS") + ":");
                for (String group : sortingList) {
                    groups.append("GROUP_PERMISSIONS".equals(type) ? "tab.sort." : "");
                    groups.append(group.replace(" ", "|"));
                    if (sortingList.indexOf(group) == sortingList.size() - 1) continue;
                    groups.append(",");
                }
                sortingTypes.add(groups.toString());
                continue;
            }
            if (type.equalsIgnoreCase("PLACEHOLDER")) {
                sortingTypes.add("PLACEHOLDER:" + sortingPlaceholder + ":" + String.join((CharSequence)",", placeholderOrder));
                continue;
            }
            sortingTypes.add(type + ":" + sortingPlaceholder);
        }
        sortingTypes.add("PLACEHOLDER_A_TO_Z:%player%");
        newConfig.set("scoreboard-teams.sorting-types", sortingTypes);
    }

    private void convertTabListFormatting(ConfigurationFile oldConfig, ConfigurationFile newConfig, ConfigurationFile premiumConfig) {
        newConfig.set("tablist-name-formatting.enabled", oldConfig.getBoolean("change-tablist-prefix-suffix", true));
        newConfig.set("tablist-name-formatting.anti-override", oldConfig.getBoolean("anti-override.tablist-names", true));
        newConfig.set("tablist-name-formatting.disable-in-worlds", oldConfig.getStringList("disable-features-in-worlds.tablist-names", Collections.singletonList("disabledworld")));
        if (TAB.getInstance().getPlatform().isProxy()) {
            newConfig.set("tablist-name-formatting.disable-in-servers", oldConfig.getStringList("disable-features-in-servers.tablist-names", Collections.singletonList("disabledserver")));
        }
        if (premiumConfig != null) {
            newConfig.set("tablist-name-formatting.align-tabsuffix-on-the-right", premiumConfig.getBoolean("align-tabsuffix-on-the-right", false));
            newConfig.set("tablist-name-formatting.character-width-overrides", premiumConfig.getConfigurationSection("character-width-overrides"));
        } else {
            newConfig.set("tablist-name-formatting.align-tabsuffix-on-the-right", false);
            newConfig.set("tablist-name-formatting.character-width-overrides", new HashMap());
        }
    }

    private void convertYellowNumber(ConfigurationFile oldConfig, ConfigurationFile newConfig) {
        newConfig.set("yellow-number-in-tablist.enabled", !oldConfig.getString("yellow-number-in-tablist", "%ping%").equals(""));
        newConfig.set("yellow-number-in-tablist.value", oldConfig.getString("yellow-number-in-tablist", "%ping%"));
        newConfig.set("yellow-number-in-tablist.disable-in-worlds", oldConfig.getStringList("disable-features-in-worlds.yellow-number", Collections.singletonList("disabledworld")));
        if (TAB.getInstance().getPlatform().isProxy()) {
            newConfig.set("yellow-number.disable-in-servers", oldConfig.getStringList("disable-features-in-servers.yellow-number", Collections.singletonList("disabledserver")));
        }
    }

    private void convertBelowName(ConfigurationFile oldConfig, ConfigurationFile newConfig) {
        newConfig.set("belowname-objective", oldConfig.getConfigurationSection("classic-vanilla-belowname"));
        newConfig.set("belowname-objective.disable-in-worlds", oldConfig.getStringList("disable-features-in-worlds.belowname", Collections.singletonList("disabledworld")));
        if (TAB.getInstance().getPlatform().isProxy()) {
            newConfig.set("belowname-objective.disable-in-servers", oldConfig.getStringList("disable-features-in-servers.belowname", Collections.singletonList("disabledserver")));
        }
    }

    private void convertBossBar(ConfigurationFile bossBar, ConfigurationFile oldConfig, ConfigurationFile newConfig) {
        String separator;
        newConfig.set("bossbar.enabled", bossBar.getBoolean("bossbar-enabled", false));
        newConfig.set("bossbar.toggle-command", bossBar.getString("bossbar-toggle-command", "/bossbar"));
        newConfig.set("bossbar.remember-toggle-choice", bossBar.getBoolean("remember-toggle-choice", false));
        newConfig.set("bossbar.hidden-by-default", bossBar.getBoolean("hidden-by-default", false));
        newConfig.set("bossbar.disable-in-worlds", bossBar.getObject("disable-features-in-worlds.bossbar"));
        if (TAB.getInstance().getPlatform().isProxy()) {
            newConfig.set("bossbar.disable-in-servers", oldConfig.getStringList("disable-features-in-servers.bossbar", Collections.singletonList("disabledserver")));
        }
        Map bars = bossBar.getConfigurationSection("bars");
        Map perWorldBossBars = bossBar.getConfigurationSection("per-world");
        ArrayList<String> activeBossBars = new ArrayList<String>(bossBar.getStringList("default-bars", new ArrayList<String>()));
        String string = separator = TAB.getInstance().getPlatform().isProxy() ? "server" : "world";
        if (perWorldBossBars != null) {
            for (Map.Entry entry : perWorldBossBars.entrySet()) {
                for (String bar : (List)entry.getValue()) {
                    if (!bars.containsKey(bar)) continue;
                    activeBossBars.add(bar);
                    if (((Map)bars.get(bar)).containsKey("display-condition")) {
                        ((Map)bars.get(bar)).put("display-condition", ((Map)bars.get(bar)).get("display-condition") + ";%" + separator + "%=" + (String)entry.getKey());
                        continue;
                    }
                    ((Map)bars.get(bar)).put("display-condition", "%" + separator + "%=" + (String)entry.getKey());
                }
            }
        }
        for (String definedBossBar : bars.keySet()) {
            ((Map)bars.get(definedBossBar)).put("announcement-bar", !activeBossBars.contains(definedBossBar));
        }
        newConfig.set("bossbar.bars", bars);
    }

    private void convertScoreboard(ConfigurationFile newConfig, ConfigurationFile premiumConfig) {
        String separator = TAB.getInstance().getPlatform().isProxy() ? "server" : "world";
        newConfig.set("scoreboard", premiumConfig.getObject("scoreboard"));
        newConfig.set("scoreboard.permission-required-to-toggle", null);
        Map scoreboards = premiumConfig.getConfigurationSection("scoreboards");
        Map perWorldScoreboards = premiumConfig.getConfigurationSection("scoreboard.per-world");
        newConfig.set("scoreboard.default-scoreboard", null);
        newConfig.set("scoreboard.per-world", null);
        for (Map.Entry entry : perWorldScoreboards.entrySet()) {
            String world = (String)entry.getKey();
            String sb = (String)entry.getValue();
            if (!scoreboards.containsKey(sb)) continue;
            Map scoreboard = (Map)scoreboards.get(sb);
            if (scoreboard.containsKey("display-condition")) {
                scoreboard.put("display-condition", ((Map)scoreboards.get(sb)).get("display-condition") + ";%" + separator + "%=" + world);
                continue;
            }
            scoreboard.put("display-condition", "%" + separator + "%=" + world);
            scoreboards.remove(sb);
            HashMap reordered = new HashMap();
            reordered.put(sb, scoreboard);
            reordered.putAll(scoreboards);
            scoreboards = reordered;
        }
        newConfig.set("scoreboard.scoreboards", scoreboards);
    }

    private void createDefaultScoreboard(ConfigurationFile newConfig) {
        newConfig.set("scoreboard.enabled", false);
        newConfig.set("scoreboard.toggle-command", "/sb");
        newConfig.set("scoreboard.remember-toggle-choice", false);
        newConfig.set("scoreboard.hidden-by-default", false);
        newConfig.set("scoreboard.use-numbers", false);
        newConfig.set("scoreboard.static-number", 0);
        newConfig.set("scoreboard.delay-on-join-milliseconds", 0);
        newConfig.set("scoreboard.respect-other-plugins", true);
        newConfig.set("scoreboard.disable-in-worlds", Collections.singletonList("disabledworld"));
        if (TAB.getInstance().getPlatform().isProxy()) {
            newConfig.set("scoreboard.disable-in-servers", Collections.singletonList("disabledserver"));
        }
        newConfig.set("scoreboard.scoreboards.admin.display-condition", "permission:tab.scoreboard.admin");
        newConfig.set("scoreboard.scoreboards.admin.title", "Admin scoreboard");
        newConfig.set("scoreboard.scoreboards.admin.lines", Arrays.asList("%animation:MyAnimation1%", "&6Online:", "* &eOnline&7: &f%online%&7/&4%maxplayers%", "* &eCurrent World&7: &f%worldonline%", "* &eStaff&7: &f%staffonline%", " ", "&6Server Info:", "* &bTPS&7: %tps%", "* &bUptime&7: &f%server_uptime%", "* &bMemory&7: &f%memory-used%&7/&4%memory-max%", "%animation:MyAnimation1%"));
        newConfig.set("scoreboard.scoreboards.scoreboard1.title", "Default");
        newConfig.set("scoreboard.scoreboards.scoreboard1.lines", Arrays.asList("%animation:MyAnimation1%", "&6My Stats:", "* &eKills&7: &f%statistic_player_kills%", "* &eDeaths&7: &f%statistic_deaths%", "* &eHealth&7: &f%health%", " ", "&6Personal Info:", "* &bRank&7: &f%group%", "* &bPing&7: &f%ping%&7ms", "* &bWorld&7: &f%world%", "%animation:MyAnimation1%"));
    }

    private void convertHeaderFooter(ConfigurationFile oldConfig, ConfigurationFile newConfig) {
        newConfig.set("header-footer.enabled", oldConfig.getBoolean("enable-header-footer", true));
        newConfig.set("header-footer.header", oldConfig.getStringList("header"));
        newConfig.set("header-footer.footer", oldConfig.getStringList("footer"));
        newConfig.set("header-footer.disable-in-worlds", oldConfig.getStringList("disable-features-in-worlds.header-footer", Collections.singletonList("disabledworld")));
        if (TAB.getInstance().getPlatform().isProxy()) {
            newConfig.set("header-footer.disable-in-servers", oldConfig.getStringList("disable-features-in-servers.header-footer", Collections.singletonList("disabledserver")));
        }
        String separator = TAB.getInstance().getPlatform().isProxy() ? "server" : "world";
        Map perWorldSettings = oldConfig.getConfigurationSection("per-" + separator + "-settings");
        LinkedHashMap headerFooterMap = new LinkedHashMap();
        for (Map.Entry worldEntry : new LinkedHashMap(perWorldSettings).entrySet()) {
            LinkedHashMap headerFooter = new LinkedHashMap();
            for (Map.Entry propertyValueEntry : new LinkedHashMap((Map)worldEntry.getValue()).entrySet()) {
                if (!((String)propertyValueEntry.getKey()).equalsIgnoreCase("header") && !((String)propertyValueEntry.getKey()).equalsIgnoreCase("footer")) continue;
                headerFooter.put((String)propertyValueEntry.getKey(), propertyValueEntry.getValue());
            }
            headerFooterMap.put(this.translateWorldGroup(oldConfig, (String)worldEntry.getKey()), headerFooter);
        }
        newConfig.set("header-footer.per-" + separator, headerFooterMap);
    }

    private void convertOtherOptions(ConfigurationFile oldConfig, ConfigurationFile newConfig, ConfigurationFile premiumConfig) {
        newConfig.set("ping-spoof", oldConfig.getConfigurationSection("ping-spoof"));
        newConfig.set("prevent-spectator-effect.enabled", oldConfig.getBoolean("do-not-move-spectators", false));
        Map placeholders = oldConfig.getConfigurationSection("placeholders");
        if (premiumConfig != null) {
            newConfig.set("placeholder-output-replacements", premiumConfig.getConfigurationSection("placeholder-output-replacements"));
            newConfig.set("conditions", premiumConfig.getConfigurationSection("conditions"));
        } else {
            newConfig.set("placeholder-output-replacements.%essentials_vanished%.yes", "&7| Vanished");
            newConfig.set("placeholder-output-replacements.%essentials_vanished%.no", "");
            newConfig.set("conditions.nick.conditions", Collections.singletonList("%player%=%essentials_nickname%"));
            newConfig.set("conditions.nick.yes", "%player%");
            newConfig.set("conditions.nick.no", "~%essentials_nickname%");
        }
        if (!TAB.getInstance().getPlatform().isProxy()) {
            newConfig.set("placeholder-output-replacements.%afk%.true", placeholders.remove("afk-yes"));
            newConfig.set("placeholder-output-replacements.%afk%.false", placeholders.remove("afk-no"));
        }
        newConfig.set("placeholders", placeholders);
        newConfig.set("placeholderapi-refresh-intervals", oldConfig.getConfigurationSection("placeholderapi-refresh-intervals"));
        newConfig.set("assign-groups-by-permissions", oldConfig.getBoolean("assign-groups-by-permissions", false));
        newConfig.set("primary-group-finding-list", oldConfig.getStringList("primary-group-finding-list", Arrays.asList("Owner", "Admin", "Mod", "Helper", "default")));
        newConfig.set("debug", oldConfig.getBoolean("debug", false));
        newConfig.set("mysql.enabled", false);
        newConfig.set("mysql.host", "127.0.0.1");
        newConfig.set("mysql.port", 3306);
        newConfig.set("mysql.database", "tab");
        newConfig.set("mysql.username", "user");
        newConfig.set("mysql.password", "password");
        if (TAB.getInstance().getPlatform().isProxy()) {
            newConfig.set("global-playerlist", oldConfig.getConfigurationSection("global-playerlist"));
            newConfig.set("global-playerlist.update-latency", false);
            newConfig.set("use-bukkit-permissions-manager", false);
        } else {
            newConfig.set("per-world-playerlist", oldConfig.getConfigurationSection("per-world-playerlist"));
            newConfig.set("fix-pet-names.enabled", oldConfig.getBoolean("fix-pet-names", false));
        }
    }

    private void convertGroupsAndUsers(ConfigurationFile oldConfig, ConfigurationFile groups, ConfigurationFile users) {
        groups.setValues(oldConfig.getConfigurationSection("Groups"));
        users.setValues(oldConfig.getConfigurationSection("Users"));
        String separator = TAB.getInstance().getPlatform().isProxy() ? "server" : "world";
        Map perWorldSettings = oldConfig.getConfigurationSection("per-" + separator + "-settings");
        LinkedHashMap groupMap = new LinkedHashMap();
        LinkedHashMap userMap = new LinkedHashMap();
        LinkedHashMap worldMap = new LinkedHashMap(perWorldSettings);
        for (Map.Entry worldEntry : worldMap.entrySet()) {
            for (Map.Entry entry2 : new LinkedHashMap((Map)worldEntry.getValue()).entrySet()) {
                if (((String)entry2.getKey()).equalsIgnoreCase("Groups")) {
                    groupMap.put(this.translateWorldGroup(oldConfig, (String)worldEntry.getKey()), entry2.getValue());
                    continue;
                }
                if (!((String)entry2.getKey()).equalsIgnoreCase("Users")) continue;
                userMap.put(this.translateWorldGroup(oldConfig, (String)worldEntry.getKey()), entry2.getValue());
            }
        }
        groups.set("per-" + separator, groupMap);
        groups.set("_DEFAULT_", groups.getConfigurationSection("_OTHER_"));
        groups.set("_OTHER_", null);
        users.set("per-" + separator, userMap);
        for (Map.Entry world : groups.getConfigurationSection("per-" + separator).keySet()) {
            String gPath = "per-" + separator + "." + world;
            if (!groups.hasConfigOption(gPath + "._OTHER_")) continue;
            groups.set(gPath + "._DEFAULT_", groups.getObject(gPath + "._OTHER_"));
            groups.set(gPath + "._OTHER_", null);
        }
    }

    private String translateWorldGroup(ConfigurationFile oldConfig, String group) {
        String oldSeparator = oldConfig.hasConfigOption("multi-world-separator") ? oldConfig.getString("multi-world-separator") : "-";
        return group.replace(oldSeparator, ";");
    }

    public void removeOldOptions(ConfigurationFile config) {
        if (config.hasConfigOption("placeholders.remove-strings")) {
            config.set("placeholders.remove-strings", null);
        }
    }
}

