/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.config;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.RowSetProvider;
import me.neznamy.tab.shared.TAB;

public class MySQL {
    private Connection con;
    private final String host;
    private final String database;
    private final String username;
    private final String password;
    private final int port;

    public MySQL(String host, int port, String database, String username, String password) throws SQLException {
        this.host = host;
        this.port = port;
        this.database = database;
        this.username = username;
        this.password = password;
        this.openConnection();
    }

    private void openConnection() throws SQLException {
        if (!this.isConnected()) {
            this.con = DriverManager.getConnection("jdbc:mysql://" + this.host + ":" + this.port + "/" + this.database, this.username, this.password);
            TAB.getInstance().getPlatform().sendConsoleMessage("&a[TAB] Successfully connected to MySQL", true);
        }
    }

    public void closeConnection() {
        if (this.isConnected()) {
            try {
                this.con.close();
            }
            catch (SQLException e) {
                TAB.getInstance().getErrorManager().printError("Failed to close MySQL connection", e);
            }
        }
    }

    private boolean isConnected() {
        try {
            return this.con != null && !this.con.isClosed();
        }
        catch (SQLException e) {
            TAB.getInstance().getErrorManager().printError("Failed to check MySQL connection", e);
            return false;
        }
    }

    public void execute(String query, Object ... vars) throws SQLException {
        try (PreparedStatement ps = this.prepareStatement(query, vars);){
            ps.execute();
        }
    }

    private PreparedStatement prepareStatement(String query, Object ... vars) throws SQLException {
        if (!this.isConnected()) {
            this.openConnection();
        }
        PreparedStatement ps = this.con.prepareStatement(query);
        int i = 0;
        if (query.contains("?") && vars.length != 0) {
            for (Object obj : vars) {
                ps.setObject(++i, obj);
            }
        }
        return ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedRowSet getCRS(String query, Object ... vars) throws SQLException {
        PreparedStatement ps = this.prepareStatement(query, vars);
        ResultSet rs = ps.executeQuery();
        try {
            CachedRowSet crs = RowSetProvider.newFactory().createCachedRowSet();
            crs.populate(rs);
            CachedRowSet cachedRowSet = crs;
            return cachedRowSet;
        }
        finally {
            rs.close();
            ps.close();
        }
    }
}

