/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.config.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import me.neznamy.tab.api.PropertyConfiguration;
import me.neznamy.tab.api.config.YamlConfigurationFile;
import me.neznamy.tab.shared.TAB;
import org.yaml.snakeyaml.error.YAMLException;

public class YamlPropertyConfigurationFile
extends YamlConfigurationFile
implements PropertyConfiguration {
    private static final String PER_SERVER = "per-server";
    private static final String PER_WORLD = "per-world";
    private static final String DEFAULT_GROUP = "_DEFAULT_";
    private final String category;
    private final List<Object> worldGroups = new ArrayList<Object>();
    private final List<Object> serverGroups = new ArrayList<Object>();

    public YamlPropertyConfigurationFile(InputStream source, File destination) throws IllegalStateException, YAMLException, IOException {
        super(source, destination);
        this.category = destination.getName().contains("groups") ? "group" : "user";
        this.serverGroups.addAll(this.getConfigurationSection(PER_SERVER).keySet());
        this.worldGroups.addAll(this.getConfigurationSection(PER_WORLD).keySet());
    }

    @Override
    public void setProperty(String name, String property, String server, String world, String value) {
        if (server != null) {
            this.set(String.format("%s.%s.%s.%s", PER_SERVER, server, name, property), value);
        } else if (world != null) {
            this.set(String.format("%s.%s.%s.%s", PER_WORLD, world, name, property), value);
        } else {
            this.set(String.format("%s.%s", name, property), value);
        }
    }

    @Override
    public String[] getProperty(String name, String property, String server, String world) {
        Object value = this.getObject(new String[]{PER_SERVER, TAB.getInstance().getConfiguration().getGroup(this.serverGroups, server), name, property});
        if (value != null) {
            return new String[]{this.toString(value), this.category + "=" + name + ", server=" + server};
        }
        value = this.getObject(new String[]{PER_SERVER, TAB.getInstance().getConfiguration().getGroup(this.serverGroups, server), DEFAULT_GROUP, property});
        if (value != null) {
            return new String[]{this.toString(value), this.category + "=" + DEFAULT_GROUP + ", server=" + server};
        }
        value = this.getObject(new String[]{PER_WORLD, TAB.getInstance().getConfiguration().getGroup(this.worldGroups, world), name, property});
        if (value != null) {
            return new String[]{this.toString(value), this.category + "=" + name + ", world=" + world};
        }
        value = this.getObject(new String[]{PER_WORLD, TAB.getInstance().getConfiguration().getGroup(this.worldGroups, world), DEFAULT_GROUP, property});
        if (value != null) {
            return new String[]{this.toString(value), this.category + "=" + DEFAULT_GROUP + ", world=" + world};
        }
        value = this.getObject(new String[]{name, property});
        if (value != null) {
            return new String[]{this.toString(value), this.category + "=" + name};
        }
        value = this.getObject(new String[]{DEFAULT_GROUP, property});
        if (value != null) {
            return new String[]{this.toString(value), this.category + "=" + DEFAULT_GROUP};
        }
        return new String[0];
    }

    private String toString(Object obj) {
        if (obj instanceof List) {
            return ((List)obj).stream().map(Object::toString).collect(Collectors.joining("\n"));
        }
        return obj.toString();
    }

    @Override
    public void remove(String name) {
        this.set(name, null);
        this.getConfigurationSection(PER_WORLD).keySet().forEach(world -> this.set("per-world." + world + "." + name, null));
        this.getConfigurationSection(PER_SERVER).keySet().forEach(server -> this.set("per-server." + server + "." + name, null));
    }
}

