/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.config.mysql;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.rowset.CachedRowSet;
import me.neznamy.tab.api.PropertyConfiguration;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.config.MySQL;

public class MySQLGroupConfiguration
implements PropertyConfiguration {
    private static final String DEFAULT_GROUP = "_DEFAULT_";
    private final MySQL mysql;
    private final Map<String, Map<String, String>> values = new HashMap<String, Map<String, String>>();
    private final Map<String, Map<String, Map<String, String>>> perWorld = new HashMap<String, Map<String, Map<String, String>>>();
    private final Map<String, Map<String, Map<String, String>>> perServer = new HashMap<String, Map<String, Map<String, String>>>();

    public MySQLGroupConfiguration(MySQL mysql) throws SQLException {
        this.mysql = mysql;
        mysql.execute("create table if not exists tab_groups (`group` varchar(64), `property` varchar(16), `value` varchar(1024), world varchar(64), server varchar(64))", new Object[0]);
        CachedRowSet crs = mysql.getCRS("select * from tab_groups", new Object[0]);
        while (crs.next()) {
            String group = crs.getString("group");
            String property = crs.getString("property");
            String value = crs.getString("value");
            String world = crs.getString("world");
            String server = crs.getString("server");
            TAB.getInstance().debug("Loaded group: " + String.format("%s, %s, %s, %s, %s", group, property, value, world, server));
            this.setProperty0(group, property, server, world, value);
        }
    }

    @Override
    public void setProperty(String group, String property, String server, String world, String value) {
        try {
            if (this.getProperty(group, property, server, world) != null) {
                this.mysql.execute("delete from `tab_groups` where `group` = ? and `property` = ? and world " + this.querySymbol(world == null) + " ? and server " + this.querySymbol(server == null) + " ?", group, property, world, server);
            }
            this.setProperty0(group, property, server, world, value);
            if (value != null) {
                this.mysql.execute("insert into `tab_groups` (`group`, `property`, `value`, `world`, `server`) values (?, ?, ?, ?, ?)", group, property, value, world, server);
            }
        }
        catch (SQLException e) {
            TAB.getInstance().getErrorManager().printError("Failed to execute MySQL query", e);
        }
    }

    private String querySymbol(boolean isNull) {
        return isNull ? "is" : "=";
    }

    private void setProperty0(String group, String property, String server, String world, String value) {
        if (server != null) {
            this.perServer.computeIfAbsent(server, s -> new HashMap()).computeIfAbsent(group, g -> new HashMap()).put(property, value);
        } else if (world != null) {
            this.perWorld.computeIfAbsent(world, w -> new HashMap()).computeIfAbsent(group, g -> new HashMap()).put(property, value);
        } else {
            this.values.computeIfAbsent(group, g -> new HashMap()).put(property, value);
        }
    }

    @Override
    public String[] getProperty(String group, String property, String server, String world) {
        String value = (String)((Map)((Map)this.perServer.getOrDefault(server, new HashMap())).getOrDefault(group, new HashMap())).get(property);
        if (value != null) {
            return new String[]{value, String.format("group=%s,server=%s", group, server)};
        }
        value = (String)((Map)((Map)this.perServer.getOrDefault(server, new HashMap())).getOrDefault(DEFAULT_GROUP, new HashMap())).get(property);
        if (value != null) {
            return new String[]{value, String.format("group=%s,server=%s", DEFAULT_GROUP, server)};
        }
        value = (String)((Map)((Map)this.perWorld.getOrDefault(world, new HashMap())).getOrDefault(group, new HashMap())).get(property);
        if (value != null) {
            return new String[]{value, String.format("group=%s,world=%s", group, world)};
        }
        value = (String)((Map)((Map)this.perWorld.getOrDefault(world, new HashMap())).getOrDefault(DEFAULT_GROUP, new HashMap())).get(property);
        if (value != null) {
            return new String[]{value, String.format("group=%s,world=%s", DEFAULT_GROUP, world)};
        }
        value = (String)((Map)this.values.getOrDefault(group, new HashMap())).get(property);
        if (value != null) {
            return new String[]{value, String.format("group=%s", group)};
        }
        value = (String)((Map)this.values.getOrDefault(DEFAULT_GROUP, new HashMap())).get(property);
        if (value != null) {
            return new String[]{value, String.format("group=%s", DEFAULT_GROUP)};
        }
        return new String[0];
    }

    @Override
    public void remove(String group) {
        ((Map)this.values.getOrDefault(group, new HashMap())).keySet().forEach(property -> this.setProperty(group, (String)property, null, null, null));
        this.perWorld.keySet().forEach(world -> ((Map)this.perWorld.get(world).getOrDefault(group, new HashMap())).keySet().forEach(property -> this.setProperty(group, (String)property, null, (String)world, null)));
        this.perServer.keySet().forEach(server -> ((Map)this.perServer.get(server).getOrDefault(group, new HashMap())).keySet().forEach(property -> this.setProperty(group, (String)property, (String)server, null, null)));
    }
}

