/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import me.neznamy.tab.api.Property;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.chat.EnumChatFormat;
import me.neznamy.tab.api.chat.IChatBaseComponent;
import me.neznamy.tab.api.protocol.PacketPlayOutPlayerInfo;
import me.neznamy.tab.api.protocol.TabPacket;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.PlayerList;

public class AlignedPlayerList
extends PlayerList {
    private int maxWidth;
    private TabPlayer maxPlayer;
    private final WeakHashMap<TabPlayer, Integer> playerWidths = new WeakHashMap();
    private final byte[] widths = new byte[65536];

    public AlignedPlayerList() {
        this.loadWidths();
    }

    private void loadWidths() {
        InputStream file = this.getClass().getClassLoader().getResourceAsStream("widths.txt");
        if (file == null) {
            TAB.getInstance().getErrorManager().criticalError("Failed to load widths.txt file. Is it inside the jar? Aligned suffix will not work.", null);
            return;
        }
        int characterId = 1;
        for (String line : new BufferedReader(new InputStreamReader(file)).lines().collect(Collectors.toList())) {
            this.widths[characterId++] = (byte)Float.parseFloat(line);
        }
        Map widthOverrides = TAB.getInstance().getConfiguration().getConfig().getConfigurationSection("tablist-name-formatting.character-width-overrides");
        for (Map.Entry entry : widthOverrides.entrySet()) {
            this.widths[((Integer)entry.getKey()).intValue()] = (byte)((Integer)entry.getValue()).intValue();
        }
    }

    public String formatNameAndUpdateLeader(TabPlayer player, TabPlayer viewer) {
        int playerNameWidth = this.getPlayerNameWidth(player);
        this.playerWidths.put(player, playerNameWidth);
        if (player == this.maxPlayer && playerNameWidth < this.maxWidth) {
            this.playerWidths.put(player, playerNameWidth);
            this.recalculateMaxWidth(null);
            this.updateAllNames(null);
        } else if (playerNameWidth > this.maxWidth) {
            this.maxWidth = playerNameWidth;
            this.maxPlayer = player;
            this.updateAllNames(player);
        }
        return this.formatName(player.getProperty("tabprefix").getFormat(viewer) + player.getProperty("customtabname").getFormat(viewer), player.getProperty("tabsuffix").getFormat(viewer));
    }

    public synchronized String formatName(String prefixAndName, String suffix) {
        if (suffix.length() == 0) {
            return prefixAndName;
        }
        int playerNameWidth = this.getTextWidth(IChatBaseComponent.fromColoredText(prefixAndName + suffix));
        StringBuilder newFormat = new StringBuilder(prefixAndName).append(EnumChatFormat.RESET.getFormat());
        int length = this.maxWidth + 12 - playerNameWidth;
        try {
            newFormat.append(this.buildSpaces(length));
        }
        catch (IllegalArgumentException e) {
            newFormat.append(this.buildSpaces(12));
        }
        return newFormat.append(EnumChatFormat.getLastColors(prefixAndName)).append(suffix).toString();
    }

    private int getTextWidth(IChatBaseComponent component) {
        Object object;
        int width = 0;
        if (component.getText() != null) {
            object = component.getText().toCharArray();
            int n = ((char[])object).length;
            for (int i = 0; i < n; ++i) {
                Character c = Character.valueOf((char)object[i]);
                width += this.widths[c.charValue()] + 1;
                if (!component.getModifier().isBold()) continue;
                ++width;
            }
        }
        object = component.getExtra().iterator();
        while (object.hasNext()) {
            IChatBaseComponent extra = (IChatBaseComponent)object.next();
            width += this.getTextWidth(extra);
        }
        return width;
    }

    private int getPlayerNameWidth(TabPlayer p) {
        String format = p.getProperty("tabprefix").getFormat(p) + p.getProperty("customtabname").getFormat(p) + p.getProperty("tabsuffix").getFormat(p);
        return this.getTextWidth(IChatBaseComponent.fromColoredText(format));
    }

    private String buildSpaces(int pixelWidth) {
        if (pixelWidth < 12) {
            throw new IllegalArgumentException("Cannot build space lower than 12 pixels wide");
        }
        int pixelsLeft = pixelWidth;
        StringBuilder output = new StringBuilder();
        while (pixelsLeft % 5 != 0) {
            pixelsLeft -= 4;
            output.append(' ');
        }
        output.append('\u00a7');
        output.append('l');
        while (pixelsLeft > 0) {
            pixelsLeft -= 5;
            output.append(' ');
        }
        output.append('\u00a7');
        output.append('r');
        return output.toString();
    }

    @Override
    public void load() {
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            this.updateProperties(all);
            this.playerWidths.put(all, this.getPlayerNameWidth(all));
            if (!this.isDisabled(all.getServer(), all.getWorld())) continue;
            this.addDisabledPlayer(all);
        }
        this.recalculateMaxWidth(null);
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            this.refresh(all, true);
        }
    }

    @Override
    public void onJoin(TabPlayer connectedPlayer) {
        this.updateProperties(connectedPlayer);
        int width = this.getPlayerNameWidth(connectedPlayer);
        this.playerWidths.put(connectedPlayer, width);
        if (width > this.maxWidth) {
            this.maxWidth = width;
            this.maxPlayer = connectedPlayer;
            this.updateAllNames(connectedPlayer);
        }
        if (this.isDisabled(connectedPlayer.getServer(), connectedPlayer.getWorld())) {
            this.addDisabledPlayer(connectedPlayer);
            return;
        }
        Runnable r = () -> {
            this.refresh(connectedPlayer, true);
            if (connectedPlayer.getVersion().getMinorVersion() < 8) {
                return;
            }
            ArrayList<PacketPlayOutPlayerInfo.PlayerInfoData> list = new ArrayList<PacketPlayOutPlayerInfo.PlayerInfoData>();
            for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
                if (all == connectedPlayer) continue;
                list.add(new PacketPlayOutPlayerInfo.PlayerInfoData(this.getTablistUUID(all, connectedPlayer), this.getTabFormat(all, connectedPlayer, false)));
            }
            if (!list.isEmpty()) {
                connectedPlayer.sendCustomPacket((TabPacket)new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.UPDATE_DISPLAY_NAME, list), this);
            }
        };
        r.run();
        if (!this.antiOverrideTabList || !TAB.getInstance().getFeatureManager().isFeatureEnabled("injection")) {
            TAB.getInstance().getCPUManager().runTaskLater(300, "processing PlayerJoinEvent", this, "Player Join", r);
        }
    }

    @Override
    public void onQuit(TabPlayer p) {
        super.onQuit(p);
        if (this.maxPlayer == p && this.recalculateMaxWidth(p)) {
            this.updateAllNames(p);
        }
    }

    @Override
    public void onWorldChange(TabPlayer p, String from, String to) {
        super.onWorldChange(p, from, to);
        int width = this.getPlayerNameWidth(p);
        if (width != this.playerWidths.get(p)) {
            this.playerWidths.put(p, width);
            this.refresh(p, true);
        }
        if (this.maxPlayer == p && this.recalculateMaxWidth(null)) {
            this.updateAllNames(null);
        }
    }

    private void updateAllNames(TabPlayer exception) {
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            if (all == exception) continue;
            this.refresh(all, true);
        }
    }

    private boolean recalculateMaxWidth(TabPlayer ignoredPlayer) {
        int newMaxWidth = 0;
        TabPlayer newMaxPlayer = null;
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            int localWidth;
            if (all == ignoredPlayer || (localWidth = this.playerWidths.get(all).intValue()) <= newMaxWidth) continue;
            newMaxWidth = localWidth;
            newMaxPlayer = all;
        }
        boolean changed = newMaxWidth != this.maxWidth;
        this.maxPlayer = newMaxPlayer;
        this.maxWidth = newMaxWidth;
        return changed;
    }

    @Override
    public IChatBaseComponent getTabFormat(TabPlayer p, TabPlayer viewer, boolean updateWidths) {
        Property prefix = p.getProperty("tabprefix");
        Property name = p.getProperty("customtabname");
        Property suffix = p.getProperty("tabsuffix");
        if (prefix == null || name == null || suffix == null) {
            return null;
        }
        String format = updateWidths ? this.formatNameAndUpdateLeader(p, viewer) : this.formatName(prefix.getFormat(viewer) + name.getFormat(viewer), suffix.getFormat(viewer));
        return IChatBaseComponent.optimizedComponent(format);
    }
}

