/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features;

import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import me.neznamy.tab.api.TabFeature;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.protocol.PacketPlayOutPlayerInfo;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardScore;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardTeam;
import me.neznamy.tab.api.protocol.TabPacket;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.BelowName;
import me.neznamy.tab.shared.features.YellowNumber;
import me.neznamy.tab.shared.features.nametags.NameTag;

public class NickCompatibility
extends TabFeature {
    private final HashMap<TabPlayer, String> nickedPlayers = new HashMap();
    private final NameTag nameTags = (NameTag)TAB.getInstance().getTeamManager();
    private final BelowName belowname = (BelowName)TAB.getInstance().getFeatureManager().getFeature("BelowName");
    private final YellowNumber yellownumber = (YellowNumber)TAB.getInstance().getFeatureManager().getFeature("YellowNumber");

    public NickCompatibility() {
        super("Nick compatibility", null);
        TAB.getInstance().debug("Loaded NickCompatibility feature");
    }

    @Override
    public void onPlayerInfo(TabPlayer receiver, PacketPlayOutPlayerInfo packet) {
        if (packet.getAction() != PacketPlayOutPlayerInfo.EnumPlayerInfoAction.ADD_PLAYER) {
            return;
        }
        for (PacketPlayOutPlayerInfo.PlayerInfoData data : packet.getEntries()) {
            TabPlayer packetPlayer = TAB.getInstance().getPlayerByTablistUUID(data.getUniqueId());
            if (packetPlayer == null || packetPlayer == receiver) continue;
            if (!packetPlayer.getName().equals(data.getName())) {
                if (this.nickedPlayers.containsKey(packetPlayer)) continue;
                this.nickedPlayers.put(packetPlayer, data.getName());
                TAB.getInstance().debug("Processing name change of player " + packetPlayer.getName() + " to " + data.getName());
                this.processNameChange(packetPlayer, data.getName());
                continue;
            }
            if (!this.nickedPlayers.containsKey(packetPlayer)) continue;
            this.nickedPlayers.remove(packetPlayer);
            TAB.getInstance().debug("Processing name restore of player " + packetPlayer.getName());
            this.processNameChange(packetPlayer, data.getName());
        }
    }

    private void processNameChange(TabPlayer player, String name) {
        TAB.getInstance().getCPUManager().runMeasuredTask("processing nickname change", this, "PacketPlayOutPlayerInfo", () -> {
            if (this.nameTags != null && !this.nameTags.hasTeamHandlingPaused(player)) {
                for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
                    viewer.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardTeam(player.getTeamName()), this);
                    String replacedPrefix = player.getProperty("tagprefix").getFormat(viewer);
                    String replacedSuffix = player.getProperty("tagsuffix").getFormat(viewer);
                    viewer.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardTeam(player.getTeamName(), replacedPrefix, replacedSuffix, this.nameTags.translate(this.nameTags.getTeamVisibility(player, viewer)), this.nameTags.translate(this.nameTags.getCollisionManager().getCollision(player)), Collections.singletonList(name), 0), this);
                }
            }
            if (this.belowname != null) {
                int value = this.belowname.getValue(player);
                for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
                    if (!all.getWorld().equals(player.getWorld()) || !Objects.equals(all.getServer(), player.getServer())) continue;
                    all.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardScore(PacketPlayOutScoreboardScore.Action.CHANGE, "TAB-BelowName", this.getNickname(player), value), this);
                }
            }
            if (this.yellownumber != null) {
                int value = this.yellownumber.getValue(player);
                for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
                    all.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardScore(PacketPlayOutScoreboardScore.Action.CHANGE, "TAB-YellowNumber", this.getNickname(player), value), this);
                }
            }
        });
    }

    public String getNickname(TabPlayer player) {
        return this.nickedPlayers.getOrDefault(player, player.getName());
    }
}

