/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features;

import java.util.ArrayList;
import me.neznamy.tab.api.TabFeature;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.protocol.PacketPlayOutPlayerInfo;
import me.neznamy.tab.api.protocol.TabPacket;
import me.neznamy.tab.shared.TAB;

public class PingSpoof
extends TabFeature {
    private final int value = TAB.getInstance().getConfiguration().getConfig().getInt("ping-spoof.value", 0);

    public PingSpoof() {
        super("Ping spoof", null);
        TAB.getInstance().debug(String.format("Loaded PingSpoof feature with parameters value=%s", this.value));
    }

    @Override
    public void onPlayerInfo(TabPlayer receiver, PacketPlayOutPlayerInfo info) {
        if (info.getAction() != PacketPlayOutPlayerInfo.EnumPlayerInfoAction.UPDATE_LATENCY && info.getAction() != PacketPlayOutPlayerInfo.EnumPlayerInfoAction.ADD_PLAYER) {
            return;
        }
        for (PacketPlayOutPlayerInfo.PlayerInfoData playerInfoData : info.getEntries()) {
            if (TAB.getInstance().getPlayerByTablistUUID(playerInfoData.getUniqueId()) == null) continue;
            playerInfoData.setLatency(this.value);
        }
    }

    @Override
    public void load() {
        this.updateAll(false);
    }

    @Override
    public void unload() {
        this.updateAll(true);
    }

    private void updateAll(boolean realPing) {
        ArrayList<PacketPlayOutPlayerInfo.PlayerInfoData> list = new ArrayList<PacketPlayOutPlayerInfo.PlayerInfoData>();
        for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
            list.add(new PacketPlayOutPlayerInfo.PlayerInfoData(p.getUniqueId(), realPing ? p.getPing() : this.value));
        }
        for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
            p.sendCustomPacket((TabPacket)new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.UPDATE_LATENCY, list), this);
        }
    }
}

