/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.placeholders.PlayerPlaceholderImpl;
import me.neznamy.tab.shared.proxy.ProxyTabPlayer;

public abstract class PluginMessageHandler {
    protected final String channelName = "tab:placeholders";

    public void requestPlaceholder(TabPlayer player, String placeholder) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF("Placeholder");
        out.writeUTF(placeholder);
        this.sendPluginMessage(player, out.toByteArray());
    }

    public void requestAttribute(TabPlayer player, String attribute) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF("Attribute");
        out.writeUTF(attribute);
        this.sendPluginMessage(player, out.toByteArray());
    }

    public void onPluginMessage(ProxyTabPlayer player, ByteArrayDataInput in) {
        if (TAB.getInstance().isDisabled()) {
            return;
        }
        String subChannel = in.readUTF();
        if (subChannel.equalsIgnoreCase("Placeholder")) {
            String placeholder = in.readUTF();
            String output = in.readUTF();
            long cpu = in.readLong();
            PlayerPlaceholderImpl pl = (PlayerPlaceholderImpl)TAB.getInstance().getPlaceholderManager().getPlaceholder(placeholder);
            pl.updateValue(player, output);
            TAB.getInstance().getCPUManager().addBridgePlaceholderTime(pl.getIdentifier(), cpu);
        }
        if ("Attribute".equals(subChannel)) {
            String attribute = in.readUTF();
            String value = in.readUTF();
            player.setAttribute(attribute, value);
            if ("world".equals(attribute)) {
                TAB.getInstance().getFeatureManager().onWorldChange(player.getUniqueId(), value);
            }
            if ("vanished".equals(attribute)) {
                ((PlayerPlaceholderImpl)TAB.getInstance().getPlaceholderManager().getPlaceholder("%vanished%")).updateValue(player, value);
            }
        }
        if ("Group".equals(subChannel)) {
            String group = in.readUTF();
            player.setGroup(group, true);
        }
    }

    public abstract void sendPluginMessage(TabPlayer var1, byte[] var2);
}

