/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.bossbar;

import me.neznamy.tab.api.TabFeature;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.protocol.PacketPlayOutBoss;
import me.neznamy.tab.api.protocol.TabPacket;
import me.neznamy.tab.shared.TabConstants;
import me.neznamy.tab.shared.features.bossbar.BossBarLine;

public class ColorAndStyleRefresher
extends TabFeature {
    private final String colorProperty;
    private final String styleProperty;
    private final BossBarLine line;

    public ColorAndStyleRefresher(BossBarLine line) {
        super("BossBar", "Updating color and style");
        this.line = line;
        this.colorProperty = TabConstants.Property.bossbarColor(line.getName());
        this.styleProperty = TabConstants.Property.bossbarStyle(line.getName());
    }

    @Override
    public void refresh(TabPlayer refreshed, boolean force) {
        if (!this.line.getPlayers().contains(refreshed)) {
            return;
        }
        refreshed.sendCustomPacket((TabPacket)new PacketPlayOutBoss(this.line.getUniqueId(), this.line.parseColor(refreshed.getProperty(this.colorProperty).updateAndGet()), this.line.parseStyle(refreshed.getProperty(this.styleProperty).updateAndGet())), "BossBar (Color and style)");
    }
}

