/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.globalplayerlist;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.neznamy.tab.api.TabFeature;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.chat.IChatBaseComponent;
import me.neznamy.tab.api.protocol.PacketPlayOutPlayerInfo;
import me.neznamy.tab.api.protocol.TabPacket;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.PlayerList;
import me.neznamy.tab.shared.features.globalplayerlist.LatencyRefresher;
import me.neznamy.tab.shared.features.globalplayerlist.VanishRefresher;

public class GlobalPlayerList
extends TabFeature {
    private final List<String> spyServers = TAB.getInstance().getConfiguration().getConfig().getStringList("global-playerlist.spy-servers", Collections.singletonList("spyserver1"));
    private final Map<String, List<String>> sharedServers = TAB.getInstance().getConfiguration().getConfig().getConfigurationSection("global-playerlist.server-groups");
    private final boolean displayAsSpectators = TAB.getInstance().getConfiguration().getConfig().getBoolean("global-playerlist.display-others-as-spectators", false);
    private final boolean vanishedAsSpectators = TAB.getInstance().getConfiguration().getConfig().getBoolean("global-playerlist.display-vanished-players-as-spectators", true);
    private final boolean isolateUnlistedServers = TAB.getInstance().getConfiguration().getConfig().getBoolean("global-playerlist.isolate-unlisted-servers", false);

    public GlobalPlayerList() {
        super("Global PlayerList", null);
        boolean updateLatency = TAB.getInstance().getConfiguration().getConfig().getBoolean("global-playerlist.update-latency", false);
        if (updateLatency) {
            TAB.getInstance().getFeatureManager().registerFeature("GlobalPlayerList-Latency", new LatencyRefresher());
        }
        TAB.getInstance().getFeatureManager().registerFeature("GlobalPlayerList-Vanish", new VanishRefresher(this));
        TAB.getInstance().debug(String.format("Loaded GlobalPlayerList feature with parameters spyServers=%s, sharedServers=%s, displayAsSpectators=%s, vanishedAsSpectators=%s, isolateUnlistedServers=%s, updateLatency=%s", this.spyServers, this.sharedServers, this.displayAsSpectators, this.vanishedAsSpectators, this.isolateUnlistedServers, updateLatency));
    }

    @Override
    public void load() {
        for (TabPlayer displayed : TAB.getInstance().getOnlinePlayers()) {
            for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
                if (viewer.getServer().equals(displayed.getServer()) || !this.shouldSee(viewer, displayed)) continue;
                viewer.sendCustomPacket((TabPacket)this.getAddPacket(displayed, viewer), this);
            }
        }
    }

    public boolean shouldSee(TabPlayer viewer, TabPlayer displayed) {
        if (displayed == viewer) {
            return true;
        }
        if (displayed.isVanished() && !viewer.hasPermission("tab.seevanished")) {
            return false;
        }
        if (this.spyServers.contains(viewer.getServer())) {
            return true;
        }
        return this.getServerGroup(viewer.getServer()).equals(this.getServerGroup(displayed.getServer()));
    }

    public String getServerGroup(String serverName) {
        for (Map.Entry<String, List<String>> group : this.sharedServers.entrySet()) {
            if (!group.getValue().contains(serverName)) continue;
            return group.getKey();
        }
        return this.isolateUnlistedServers ? "isolated:" + serverName : "DEFAULT";
    }

    @Override
    public void unload() {
        for (TabPlayer displayed : TAB.getInstance().getOnlinePlayers()) {
            PacketPlayOutPlayerInfo displayedRemovePacket = this.getRemovePacket(displayed);
            for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
                if (displayed.getServer().equals(viewer.getServer())) continue;
                viewer.sendCustomPacket((TabPacket)displayedRemovePacket, this);
            }
        }
    }

    @Override
    public void onJoin(TabPlayer connectedPlayer) {
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            if (all == connectedPlayer) continue;
            if (this.shouldSee(all, connectedPlayer)) {
                all.sendCustomPacket((TabPacket)this.getAddPacket(connectedPlayer, all), this);
            }
            if (!this.shouldSee(connectedPlayer, all)) continue;
            connectedPlayer.sendCustomPacket((TabPacket)this.getAddPacket(all, connectedPlayer), this);
        }
    }

    @Override
    public void onQuit(TabPlayer disconnectedPlayer) {
        TAB.getInstance().getCPUManager().runTaskLater(50, "removing players", this, "Player Quit", () -> {
            PacketPlayOutPlayerInfo remove = this.getRemovePacket(disconnectedPlayer);
            for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
                if (all == disconnectedPlayer) continue;
                all.sendCustomPacket((TabPacket)remove, this);
            }
        });
    }

    @Override
    public void onServerChange(TabPlayer p, String from, String to) {
        PacketPlayOutPlayerInfo removeChanged = this.getRemovePacket(p);
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            if (all == p) continue;
            if (this.shouldSee(all, p)) {
                all.sendCustomPacket((TabPacket)this.getAddPacket(p, all), this);
            } else {
                all.sendCustomPacket((TabPacket)removeChanged, this);
            }
            if (this.shouldSee(p, all)) {
                p.sendCustomPacket((TabPacket)this.getAddPacket(all, p), this);
                continue;
            }
            p.sendCustomPacket((TabPacket)this.getRemovePacket(all), this);
        }
    }

    public PacketPlayOutPlayerInfo getRemovePacket(TabPlayer p) {
        PacketPlayOutPlayerInfo.PlayerInfoData data = new PacketPlayOutPlayerInfo.PlayerInfoData(p.getTablistUUID());
        data.setName(p.getName());
        return new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.REMOVE_PLAYER, data);
    }

    public PacketPlayOutPlayerInfo getAddPacket(TabPlayer p, TabPlayer viewer) {
        IChatBaseComponent format = null;
        PlayerList playerlist = (PlayerList)TAB.getInstance().getFeatureManager().getFeature("PlayerList");
        if (playerlist != null) {
            format = playerlist.getTabFormat(p, viewer, false);
        }
        return new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.ADD_PLAYER, new PacketPlayOutPlayerInfo.PlayerInfoData(p.getName(), p.getTablistUUID(), p.getSkin(), p.getPing(), this.vanishedAsSpectators && p.isVanished() ? PacketPlayOutPlayerInfo.EnumGamemode.SPECTATOR : PacketPlayOutPlayerInfo.EnumGamemode.CREATIVE, format));
    }

    @Override
    public void onPlayerInfo(TabPlayer receiver, PacketPlayOutPlayerInfo info) {
        TabPlayer packetPlayer;
        if (info.getAction() == PacketPlayOutPlayerInfo.EnumPlayerInfoAction.REMOVE_PLAYER) {
            for (PacketPlayOutPlayerInfo.PlayerInfoData playerInfoData : info.getEntries()) {
                packetPlayer = TAB.getInstance().getPlayerByTablistUUID(playerInfoData.getUniqueId());
                if (packetPlayer == null || playerInfoData.getName() != null && playerInfoData.getName().length() != 0 || packetPlayer.isVanished()) continue;
                playerInfoData.setUniqueId(UUID.randomUUID());
            }
        }
        if (!this.displayAsSpectators) {
            return;
        }
        if (info.getAction() == PacketPlayOutPlayerInfo.EnumPlayerInfoAction.ADD_PLAYER || info.getAction() == PacketPlayOutPlayerInfo.EnumPlayerInfoAction.UPDATE_GAME_MODE) {
            for (PacketPlayOutPlayerInfo.PlayerInfoData playerInfoData : info.getEntries()) {
                packetPlayer = TAB.getInstance().getPlayerByTablistUUID(playerInfoData.getUniqueId());
                if (packetPlayer == null || receiver.getServer().equals(packetPlayer.getServer())) continue;
                playerInfoData.setGameMode(PacketPlayOutPlayerInfo.EnumGamemode.SPECTATOR);
            }
        }
    }

    public List<String> getSpyServers() {
        return this.spyServers;
    }
}

