/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.globalplayerlist;

import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import me.neznamy.tab.api.TabFeature;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.protocol.TabPacket;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.globalplayerlist.GlobalPlayerList;

public class VanishRefresher
extends TabFeature {
    private final GlobalPlayerList playerList;
    private final Set<TabPlayer> vanishedPlayers = Collections.newSetFromMap(new WeakHashMap());

    protected VanishRefresher(GlobalPlayerList playerList) {
        super("Global PlayerList", "Updating vanished players");
        this.playerList = playerList;
        TAB.getInstance().getPlaceholderManager().addUsedPlaceholder("%vanished%", this);
    }

    @Override
    public void refresh(TabPlayer p, boolean force) {
        if (this.vanishedPlayers.contains(p) && !p.isVanished()) {
            this.vanishedPlayers.remove(p);
            for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
                if (viewer == p || !this.playerList.shouldSee(viewer, p)) continue;
                viewer.sendCustomPacket((TabPacket)this.playerList.getAddPacket(p, viewer), "Global PlayerList (Vanishing)");
            }
        }
        if (!this.vanishedPlayers.contains(p) && p.isVanished()) {
            this.vanishedPlayers.add(p);
            for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
                if (all == p || this.playerList.shouldSee(all, p)) continue;
                all.sendCustomPacket((TabPacket)this.playerList.getRemovePacket(p), "Global PlayerList (Vanishing)");
            }
        }
    }
}

