/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.layout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.shared.features.layout.Layout;
import me.neznamy.tab.shared.features.layout.PlayerSlot;
import me.neznamy.tab.shared.placeholders.conditions.Condition;

public class ParentGroup {
    private final Layout layout;
    private final Condition condition;
    private final int[] slots;
    private final Map<Integer, PlayerSlot> playerSlots = new HashMap<Integer, PlayerSlot>();
    private final Map<TabPlayer, PlayerSlot> players = new HashMap<TabPlayer, PlayerSlot>();

    public ParentGroup(Layout layout, Condition condition, int[] slots) {
        this.layout = layout;
        this.condition = condition;
        if (condition != null) {
            layout.addUsedPlaceholders(Collections.singletonList("%condition:" + condition.getName() + "%"));
        }
        this.slots = slots;
        for (int slot : slots) {
            this.playerSlots.put(slot, new PlayerSlot(layout, layout.getManager().getUUID(slot)));
        }
    }

    public void tick(List<TabPlayer> remainingPlayers) {
        this.players.clear();
        ArrayList<TabPlayer> meetingCondition = new ArrayList<TabPlayer>();
        for (TabPlayer p : remainingPlayers) {
            if (this.condition != null && !this.condition.isMet(p)) continue;
            meetingCondition.add(p);
        }
        remainingPlayers.removeAll(meetingCondition);
        for (int index = 0; index < this.slots.length; ++index) {
            int slot = this.slots[index];
            if (this.layout.getManager().isRemainingPlayersTextEnabled() && index == this.slots.length - 1 && this.playerSlots.size() < meetingCondition.size()) {
                this.playerSlots.get(slot).setText(String.format(this.layout.getManager().getRemainingPlayersText(), meetingCondition.size() - this.playerSlots.size() + 1));
                break;
            }
            if (meetingCondition.size() > index) {
                TabPlayer p = (TabPlayer)meetingCondition.get(index);
                this.playerSlots.get(slot).setPlayer(p);
                this.players.put(p, this.playerSlots.get(slot));
                continue;
            }
            this.playerSlots.get(slot).setText("");
        }
    }

    public void sendTo(TabPlayer p) {
        this.playerSlots.values().forEach(s -> s.sendSlot(p));
    }

    public Map<TabPlayer, PlayerSlot> getPlayers() {
        return this.players;
    }
}

