/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.layout;

import java.util.UUID;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.chat.IChatBaseComponent;
import me.neznamy.tab.api.protocol.PacketPlayOutPlayerInfo;
import me.neznamy.tab.api.protocol.TabPacket;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.PlayerList;
import me.neznamy.tab.shared.features.layout.Layout;

public class PlayerSlot {
    private final PlayerList playerlist = (PlayerList)TAB.getInstance().getFeatureManager().getFeature("PlayerList");
    private final Layout layout;
    private final UUID id;
    private TabPlayer player;
    private String text = "";

    public PlayerSlot(Layout layout, UUID id) {
        this.layout = layout;
        this.id = id;
    }

    public UUID getUUID() {
        return this.id;
    }

    public void setPlayer(TabPlayer newPlayer) {
        if (this.player == newPlayer) {
            return;
        }
        this.player = newPlayer;
        if (this.player != null) {
            this.text = "";
        }
        PacketPlayOutPlayerInfo packet = new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.REMOVE_PLAYER, new PacketPlayOutPlayerInfo.PlayerInfoData(this.id));
        for (TabPlayer viewer : this.layout.getViewers()) {
            if (viewer.getVersion().getMinorVersion() < 8 || viewer.isBedrockPlayer()) continue;
            viewer.sendCustomPacket((TabPacket)packet, "Layout (Player slots)");
            this.sendSlot(viewer);
        }
    }

    public void sendSlot(TabPlayer p) {
        if (p.getVersion().getMinorVersion() < 8 || p.isBedrockPlayer()) {
            return;
        }
        TabPlayer player = this.player;
        PacketPlayOutPlayerInfo.PlayerInfoData data = player != null ? new PacketPlayOutPlayerInfo.PlayerInfoData("", this.id, player.getSkin(), player.getPing(), PacketPlayOutPlayerInfo.EnumGamemode.SURVIVAL, this.playerlist == null ? new IChatBaseComponent(player.getName()) : this.playerlist.getTabFormat(player, p, false)) : new PacketPlayOutPlayerInfo.PlayerInfoData("", this.id, this.layout.getManager().getSkinManager().getDefaultSkin(), 0, PacketPlayOutPlayerInfo.EnumGamemode.SURVIVAL, new IChatBaseComponent(this.text));
        p.sendCustomPacket((TabPacket)new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.ADD_PLAYER, data), "Layout (Player slots)");
    }

    public void setText(String text) {
        if (this.text.equals(text) && this.player == null) {
            return;
        }
        this.text = text;
        if (this.player != null) {
            this.setPlayer(null);
        } else {
            PacketPlayOutPlayerInfo packet = new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.UPDATE_DISPLAY_NAME, new PacketPlayOutPlayerInfo.PlayerInfoData(this.id, IChatBaseComponent.optimizedComponent(text)));
            for (TabPlayer all : this.layout.getViewers()) {
                if (all.getVersion().getMinorVersion() < 8 || all.isBedrockPlayer()) continue;
                all.sendCustomPacket((TabPacket)packet, "Layout (Player slots)");
            }
        }
    }
}

