/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.nametags;

import java.util.Collections;
import java.util.WeakHashMap;
import me.neznamy.tab.api.TabFeature;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.nametags.NameTag;

public class CollisionManager
extends TabFeature {
    private final NameTag nameTags;
    private final boolean collisionRule;
    private final WeakHashMap<TabPlayer, Boolean> collision = new WeakHashMap();
    private final WeakHashMap<TabPlayer, Boolean> forcedCollision = new WeakHashMap();

    public CollisionManager(NameTag nameTags, boolean collisionRule) {
        super(nameTags.getFeatureName(), "Updating collision");
        this.nameTags = nameTags;
        this.collisionRule = collisionRule;
        if (TAB.getInstance().getServerVersion().getMinorVersion() < 9) {
            return;
        }
        if (!collisionRule) {
            return;
        }
        if (!TAB.getInstance().getPlatform().isPluginEnabled("LibsDisguises") && !TAB.getInstance().getPlatform().isProxy()) {
            return;
        }
        TAB.getInstance().getPlaceholderManager().registerPlayerPlaceholder("%collision%", 500, p -> {
            if (this.forcedCollision.containsKey(p)) {
                return this.forcedCollision.get(p);
            }
            boolean newCollision = !p.isDisguised();
            this.collision.put((TabPlayer)p, newCollision);
            return newCollision;
        });
        this.addUsedPlaceholders(Collections.singletonList("%collision%"));
    }

    public boolean getCollision(TabPlayer p) {
        return this.forcedCollision.getOrDefault(p, this.collision.getOrDefault(p, this.collisionRule));
    }

    @Override
    public void load() {
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            this.collision.put(all, this.collisionRule);
        }
    }

    @Override
    public void onJoin(TabPlayer connectedPlayer) {
        this.collision.put(connectedPlayer, this.collisionRule);
    }

    @Override
    public void refresh(TabPlayer p, boolean force) {
        if (this.nameTags.isDisabledPlayer(p)) {
            return;
        }
        this.nameTags.updateTeamData(p);
    }

    public void setCollisionRule(TabPlayer player, Boolean collision) {
        if (this.forcedCollision.get(player) == collision) {
            return;
        }
        if (collision == null) {
            this.forcedCollision.remove(player);
        } else {
            this.forcedCollision.put(player, collision);
        }
        this.nameTags.updateTeamData(player);
    }

    public Boolean getCollisionRule(TabPlayer player) {
        return this.forcedCollision.get(player);
    }
}

