/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.scoreboard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import me.neznamy.tab.api.TabFeature;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardDisplayObjective;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardObjective;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardScore;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardTeam;
import me.neznamy.tab.api.protocol.TabPacket;
import me.neznamy.tab.api.scoreboard.Line;
import me.neznamy.tab.api.scoreboard.Scoreboard;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.TabConstants;
import me.neznamy.tab.shared.features.scoreboard.ScoreboardManagerImpl;
import me.neznamy.tab.shared.features.scoreboard.lines.CustomLine;
import me.neznamy.tab.shared.features.scoreboard.lines.LongLine;
import me.neznamy.tab.shared.features.scoreboard.lines.ScoreboardLine;
import me.neznamy.tab.shared.features.scoreboard.lines.StableDynamicLine;
import me.neznamy.tab.shared.features.scoreboard.lines.StaticLine;
import me.neznamy.tab.shared.placeholders.conditions.Condition;

public class ScoreboardImpl
extends TabFeature
implements Scoreboard {
    private final ScoreboardManagerImpl manager;
    private final String name;
    private String title;
    private Condition displayCondition;
    private final List<Line> lines = new ArrayList<Line>();
    private final Set<TabPlayer> players = Collections.newSetFromMap(new WeakHashMap());

    public ScoreboardImpl(ScoreboardManagerImpl manager, String name, String title, List<String> lines, String displayCondition) {
        this(manager, name, title, lines, false);
        this.displayCondition = Condition.getCondition(displayCondition);
        if (this.displayCondition != null) {
            manager.addUsedPlaceholders(Collections.singletonList("%condition:" + this.displayCondition.getName() + "%"));
        }
    }

    public ScoreboardImpl(ScoreboardManagerImpl manager, String name, String title, List<String> lines, boolean dynamicLinesOnly) {
        super(manager.getFeatureName(), "Updating scoreboard title");
        this.manager = manager;
        this.name = name;
        this.title = title;
        for (int i = 0; i < lines.size(); ++i) {
            ScoreboardLine score = dynamicLinesOnly ? new StableDynamicLine(this, i + 1, lines.get(i)) : this.registerLine(i + 1, lines.get(i));
            this.lines.add(score);
            TAB.getInstance().getFeatureManager().registerFeature(TabConstants.Feature.scoreboardLine(name, i), score);
        }
    }

    private ScoreboardLine registerLine(int lineNumber, String text) {
        if (text.startsWith("Custom|")) {
            String[] elements = text.split("\\|");
            return new CustomLine(this, lineNumber, elements[1], elements[2], elements[3], Integer.parseInt(elements[4]));
        }
        if (text.startsWith("Long|")) {
            return new LongLine(this, lineNumber, text.substring(5));
        }
        if (text.contains("%") || this.manager.isUsingNumbers() && text.length() <= 26) {
            return new StableDynamicLine(this, lineNumber, text);
        }
        return new StaticLine(this, lineNumber, text);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isConditionMet(TabPlayer p) {
        return this.displayCondition == null || this.displayCondition.isMet(p);
    }

    public void addPlayer(TabPlayer p) {
        if (this.players.contains(p)) {
            return;
        }
        this.players.add(p);
        p.setProperty(this, "scoreboard-title", this.title);
        p.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardObjective(0, "TAB-Scoreboard", p.getProperty("scoreboard-title").get(), PacketPlayOutScoreboardObjective.EnumScoreboardHealthDisplay.INTEGER), "Scoreboard (Title)");
        p.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardDisplayObjective(1, "TAB-Scoreboard"), "Scoreboard (Title)");
        for (Line s : this.lines) {
            ((ScoreboardLine)s).register(p);
        }
        this.manager.getActiveScoreboards().put(p, this);
        this.recalculateScores(p);
    }

    @Override
    public void unregister() {
        for (TabPlayer all : this.getPlayers().toArray(new TabPlayer[0])) {
            this.removePlayer(all);
        }
        this.players.clear();
    }

    public void removePlayer(TabPlayer p) {
        if (!this.players.contains(p)) {
            return;
        }
        p.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardObjective("TAB-Scoreboard"), this);
        for (Line line : this.lines) {
            p.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardTeam(((ScoreboardLine)line).getTeamName()), "Scoreboard (Lines)");
        }
        this.players.remove(p);
        this.manager.getActiveScoreboards().remove(p);
    }

    @Override
    public void refresh(TabPlayer refreshed, boolean force) {
        if (refreshed.getProperty("scoreboard-title") == null) {
            return;
        }
        refreshed.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardObjective(2, "TAB-Scoreboard", refreshed.getProperty("scoreboard-title").updateAndGet(), PacketPlayOutScoreboardObjective.EnumScoreboardHealthDisplay.INTEGER), "Scoreboard (Title)");
    }

    @Override
    public List<Line> getLines() {
        return this.lines;
    }

    public Set<TabPlayer> getPlayers() {
        return this.players;
    }

    public ScoreboardManagerImpl getManager() {
        return this.manager;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
        for (TabPlayer p : this.players) {
            p.setProperty(this, "scoreboard-title", title);
            this.refresh(p, false);
        }
    }

    @Override
    public void addLine(String text) {
        StableDynamicLine line = new StableDynamicLine(this, this.lines.size() + 1, text);
        TAB.getInstance().getFeatureManager().registerFeature(TabConstants.Feature.scoreboardLine(this.name, this.lines.size()), line);
        this.lines.add(line);
        for (TabPlayer p : this.players) {
            line.register(p);
            this.recalculateScores(p);
        }
    }

    @Override
    public void removeLine(int index) {
        if (index < 0 || index >= this.lines.size()) {
            throw new IndexOutOfBoundsException("Index " + index + " is out of range (0 - " + (this.lines.size() - 1) + ")");
        }
        ScoreboardLine line = (ScoreboardLine)this.lines.get(index);
        this.lines.remove(line);
        for (TabPlayer p : this.players) {
            line.unregister(p);
            this.recalculateScores(p);
        }
        TAB.getInstance().getFeatureManager().unregisterFeature(TabConstants.Feature.scoreboardLine(this.name, index));
    }

    public void recalculateScores(TabPlayer p) {
        if (!this.manager.isUsingNumbers()) {
            return;
        }
        ArrayList<Line> linesReversed = new ArrayList<Line>(this.lines);
        Collections.reverse(linesReversed);
        int score = 1;
        for (Line line : linesReversed) {
            if (line instanceof CustomLine) {
                ++score;
                continue;
            }
            if (!(line instanceof StaticLine) && p.getProperty(this.getName() + "-" + ((ScoreboardLine)line).getTeamName()).get().length() <= 0) continue;
            p.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardScore(PacketPlayOutScoreboardScore.Action.CHANGE, "TAB-Scoreboard", ((ScoreboardLine)line).getPlayerName(), score++), this);
        }
    }
}

