/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.scoreboard.lines;

import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardTeam;
import me.neznamy.tab.api.protocol.TabPacket;
import me.neznamy.tab.shared.TabConstants;
import me.neznamy.tab.shared.features.scoreboard.ScoreboardImpl;
import me.neznamy.tab.shared.features.scoreboard.lines.ScoreboardLine;

public class CustomLine
extends ScoreboardLine {
    private String prefix;
    private String name;
    private String suffix;
    private final int score;

    public CustomLine(ScoreboardImpl parent, int lineNumber, String prefix, String name, String suffix, int score) {
        super(parent, lineNumber);
        this.prefix = prefix;
        this.name = name;
        this.suffix = suffix;
        this.score = score;
    }

    @Override
    public void refresh(TabPlayer refreshed, boolean force) {
        if (!this.parent.getPlayers().contains(refreshed)) {
            return;
        }
        String oldName = refreshed.getProperty(TabConstants.Property.scoreboardName(this.parent.getName(), this.lineNumber)).get();
        boolean prefixUpdate = refreshed.getProperty(TabConstants.Property.scoreboardPrefix(this.parent.getName(), this.lineNumber)).update();
        boolean nameUpdate = refreshed.getProperty(TabConstants.Property.scoreboardName(this.parent.getName(), this.lineNumber)).update();
        boolean suffixUpdate = refreshed.getProperty(TabConstants.Property.scoreboardSuffix(this.parent.getName(), this.lineNumber)).update();
        if (prefixUpdate || nameUpdate || suffixUpdate) {
            if (nameUpdate) {
                this.removeLine(refreshed, oldName);
                this.addLine(refreshed, refreshed.getProperty(TabConstants.Property.scoreboardName(this.parent.getName(), this.lineNumber)).get(), refreshed.getProperty(TabConstants.Property.scoreboardPrefix(this.parent.getName(), this.lineNumber)).get(), refreshed.getProperty(TabConstants.Property.scoreboardSuffix(this.parent.getName(), this.lineNumber)).get());
            } else {
                refreshed.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardTeam(this.teamName, refreshed.getProperty(TabConstants.Property.scoreboardPrefix(this.parent.getName(), this.lineNumber)).get(), refreshed.getProperty(TabConstants.Property.scoreboardSuffix(this.parent.getName(), this.lineNumber)).get(), "always", "always", 0), "Scoreboard (Lines)");
            }
        }
    }

    @Override
    public void register(TabPlayer p) {
        p.setProperty(this, TabConstants.Property.scoreboardPrefix(this.parent.getName(), this.lineNumber), this.prefix);
        p.setProperty(this, TabConstants.Property.scoreboardName(this.parent.getName(), this.lineNumber), this.name);
        p.setProperty(this, TabConstants.Property.scoreboardSuffix(this.parent.getName(), this.lineNumber), this.suffix);
        this.addLine(p, p.getProperty(TabConstants.Property.scoreboardName(this.parent.getName(), this.lineNumber)).get(), p.getProperty(TabConstants.Property.scoreboardPrefix(this.parent.getName(), this.lineNumber)).get(), p.getProperty(TabConstants.Property.scoreboardSuffix(this.parent.getName(), this.lineNumber)).get());
    }

    @Override
    public void unregister(TabPlayer p) {
        if (this.parent.getPlayers().contains(p)) {
            this.removeLine(p, p.getProperty(TabConstants.Property.scoreboardName(this.parent.getName(), this.lineNumber)).get());
        }
    }

    @Override
    public void setText(String text) {
        this.text = text;
        String[] elements = text.split("\\|");
        this.prefix = elements[0];
        this.name = elements[1];
        this.suffix = elements[2];
    }

    @Override
    public int getNumber(TabPlayer p) {
        return this.score;
    }
}

