/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.scoreboard.lines;

import java.util.Collections;
import me.neznamy.tab.api.TabFeature;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.chat.EnumChatFormat;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardScore;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardTeam;
import me.neznamy.tab.api.protocol.TabPacket;
import me.neznamy.tab.api.scoreboard.Line;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.scoreboard.ScoreboardImpl;

public abstract class ScoreboardLine
extends TabFeature
implements Line {
    protected final int lineNumber;
    protected String text;
    protected final ScoreboardImpl parent;
    protected final String teamName;
    protected final String playerName;

    protected ScoreboardLine(ScoreboardImpl parent, int lineNumber) {
        super(parent.getFeatureName(), "Updating scoreboard lines");
        this.parent = parent;
        this.lineNumber = lineNumber;
        this.teamName = "TAB-SB-TM-" + lineNumber;
        this.playerName = this.getPlayerName(lineNumber);
    }

    public abstract void register(TabPlayer var1);

    public abstract void unregister(TabPlayer var1);

    protected String[] split(String string, int firstElementMaxLength) {
        if (string.length() <= firstElementMaxLength) {
            return new String[]{string, ""};
        }
        int splitIndex = firstElementMaxLength;
        if (string.charAt(splitIndex - 1) == '\u00a7') {
            --splitIndex;
        }
        return new String[]{string.substring(0, splitIndex), string.substring(splitIndex)};
    }

    public String getPlayerName() {
        return this.playerName;
    }

    protected String getPlayerName(int lineNumber) {
        String id = String.valueOf(lineNumber);
        if (id.length() == 1) {
            id = "0" + id;
        }
        return EnumChatFormat.COLOR_STRING + id.charAt(0) + EnumChatFormat.COLOR_STRING + id.charAt(1) + EnumChatFormat.COLOR_STRING + "r";
    }

    protected void addLine(TabPlayer p, String fakePlayer, String prefix, String suffix) {
        p.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardScore(PacketPlayOutScoreboardScore.Action.CHANGE, "TAB-Scoreboard", fakePlayer, this.getNumber(p)), "Scoreboard (Lines)");
        if (p.getVersion().getMinorVersion() >= 8 && TAB.getInstance().getConfiguration().isUnregisterBeforeRegister()) {
            p.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardTeam(this.teamName), "Scoreboard (Lines)");
        }
        p.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardTeam(this.teamName, prefix, suffix, "never", "never", Collections.singletonList(fakePlayer), 0), "Scoreboard (Lines)");
    }

    protected void removeLine(TabPlayer p, String fakePlayer) {
        p.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardScore(PacketPlayOutScoreboardScore.Action.REMOVE, "TAB-Scoreboard", fakePlayer, 0), "Scoreboard (Lines)");
        p.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardTeam(this.teamName), "Scoreboard (Lines)");
    }

    @Override
    public String getText() {
        return this.text;
    }

    public int getNumber(TabPlayer p) {
        if (this.parent.getManager().isUsingNumbers() || p.getVersion().getMinorVersion() < 8 || p.isBedrockPlayer()) {
            return this.parent.getLines().size() + 1 - this.lineNumber;
        }
        return this.parent.getManager().getStaticNumber();
    }

    public String getTeamName() {
        return this.teamName;
    }

    protected String[] splitText(String playerNameStart, String text, int maxNameLength) {
        String suffixValue;
        String nameValue;
        String prefixValue;
        if (text.length() <= maxNameLength - playerNameStart.length()) {
            prefixValue = "";
            nameValue = playerNameStart + text;
            suffixValue = "";
        } else {
            String[] prefixOther = this.split(text, 16);
            prefixValue = prefixOther[0];
            String other = prefixOther[1];
            if (playerNameStart.length() > 0) {
                other = playerNameStart + EnumChatFormat.getLastColors(prefixValue) + other;
            }
            String[] nameSuffix = this.split(other, maxNameLength);
            nameValue = nameSuffix[0];
            suffixValue = nameSuffix[1];
        }
        return new String[]{prefixValue, nameValue, suffixValue};
    }
}

