/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.scoreboard.lines;

import me.neznamy.tab.api.Property;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.chat.EnumChatFormat;
import me.neznamy.tab.api.chat.rgb.RGBUtils;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardTeam;
import me.neznamy.tab.api.protocol.TabPacket;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.scoreboard.ScoreboardImpl;
import me.neznamy.tab.shared.features.scoreboard.lines.ScoreboardLine;

public class StableDynamicLine
extends ScoreboardLine {
    private static final String[] EMPTY_ARRAY = new String[0];

    public StableDynamicLine(ScoreboardImpl parent, int lineNumber, String text) {
        super(parent, lineNumber);
        this.text = text;
    }

    @Override
    public void refresh(TabPlayer refreshed, boolean force) {
        if (!this.parent.getPlayers().contains(refreshed)) {
            return;
        }
        String[] prefixSuffix = this.replaceText(refreshed, force, false);
        if (prefixSuffix.length == 0) {
            return;
        }
        refreshed.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardTeam(this.teamName, prefixSuffix[0], prefixSuffix[1], "always", "always", 0), "Scoreboard (Lines)");
    }

    @Override
    public void register(TabPlayer p) {
        p.setProperty(this, this.parent.getName() + "-" + this.teamName, this.text);
        String[] prefixSuffix = this.replaceText(p, true, true);
        if (prefixSuffix.length == 0) {
            return;
        }
        this.addLine(p, this.getPlayerName(), prefixSuffix[0], prefixSuffix[1]);
    }

    @Override
    public void unregister(TabPlayer p) {
        if (this.parent.getPlayers().contains(p) && p.getProperty(this.parent.getName() + "-" + this.teamName).get().length() > 0) {
            this.removeLine(p, this.getPlayerName());
        }
    }

    private String[] replaceText(TabPlayer p, boolean force, boolean suppressToggle) {
        boolean emptyBefore;
        Property scoreProperty = p.getProperty(this.parent.getName() + "-" + this.teamName);
        if (scoreProperty == null) {
            return EMPTY_ARRAY;
        }
        boolean bl = emptyBefore = scoreProperty.get().length() == 0;
        if (!scoreProperty.update() && !force) {
            return EMPTY_ARRAY;
        }
        String replaced = scoreProperty.get();
        if (p.getVersion().getMinorVersion() < 16) {
            replaced = RGBUtils.getInstance().convertRGBtoLegacy(replaced);
        }
        String[] split = this.split(p, replaced);
        if (replaced.length() > 0) {
            if (emptyBefore) {
                this.addLine(p, this.getPlayerName(), split[0], split[1]);
                this.parent.recalculateScores(p);
                return EMPTY_ARRAY;
            }
            return split;
        }
        if (!suppressToggle) {
            this.removeLine(p, this.getPlayerName());
            this.parent.recalculateScores(p);
        }
        return EMPTY_ARRAY;
    }

    private String[] split(TabPlayer p, String text) {
        int charLimit = 16;
        if (!TAB.getInstance().getPlatform().isProxy() && TAB.getInstance().getServerVersion().getMinorVersion() >= 13 && p.getVersion().getMinorVersion() < 13) {
            String lastColors = EnumChatFormat.getLastColors(text.substring(0, Math.min(16, text.length())));
            charLimit -= lastColors.length() == 0 ? 2 : lastColors.length();
        }
        if (text.length() > charLimit && p.getVersion().getMinorVersion() < 13) {
            StringBuilder prefix = new StringBuilder(text);
            StringBuilder suffix = new StringBuilder(text);
            prefix.setLength(charLimit);
            suffix.delete(0, charLimit);
            if (prefix.charAt(charLimit - 1) == '\u00a7') {
                prefix.setLength(prefix.length() - 1);
                suffix.insert(0, '\u00a7');
            }
            String prefixString = prefix.toString();
            suffix.insert(0, EnumChatFormat.getLastColors(RGBUtils.getInstance().convertRGBtoLegacy(prefixString)));
            return new String[]{prefixString, suffix.toString()};
        }
        return new String[]{text, ""};
    }

    @Override
    public void setText(String text) {
        this.text = text;
        for (TabPlayer p : this.parent.getPlayers()) {
            p.setProperty(this, this.teamName, text);
            this.refresh(p, true);
        }
    }
}

