/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.scoreboard.lines;

import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.chat.EnumChatFormat;
import me.neznamy.tab.api.chat.rgb.RGBUtils;
import me.neznamy.tab.shared.features.scoreboard.ScoreboardImpl;
import me.neznamy.tab.shared.features.scoreboard.lines.ScoreboardLine;

public class StaticLine
extends ScoreboardLine {
    protected String prefix17;
    protected String name17;
    protected String suffix17;
    protected String prefix;
    protected String name;
    protected String suffix;

    public StaticLine(ScoreboardImpl parent, int lineNumber, String text) {
        super(parent, lineNumber);
        this.text = EnumChatFormat.color(text);
        this.setValues(this.text);
    }

    private void setValues(String text) {
        this.text = text;
        String forcedNameStart = this.parent.getManager().isUsingNumbers() ? "" : this.getPlayerName(this.lineNumber);
        String legacy = RGBUtils.getInstance().convertRGBtoLegacy(this.text);
        String[] v18 = this.splitText(forcedNameStart, legacy, 40);
        this.prefix = v18[0];
        this.name = v18[1];
        this.suffix = v18[2];
        String[] v17 = this.splitText(forcedNameStart, legacy, 16);
        this.prefix17 = v17[0];
        this.name17 = v17[1];
        this.suffix17 = v17[2];
    }

    protected String getPlayerName(TabPlayer viewer) {
        if (viewer.getVersion().getMinorVersion() >= 13) {
            return this.playerName;
        }
        if (viewer.getVersion().getMinorVersion() >= 8) {
            return this.name;
        }
        return this.name17;
    }

    @Override
    public void register(TabPlayer p) {
        if (p.getVersion().getMinorVersion() >= 13) {
            this.addLine(p, this.playerName, this.text, "");
        } else if (p.getVersion().getMinorVersion() >= 8) {
            this.addLine(p, this.name, this.prefix, this.suffix);
        } else {
            this.addLine(p, this.name17, this.prefix17, this.suffix17);
        }
    }

    @Override
    public void unregister(TabPlayer p) {
        if (this.text.length() > 0) {
            this.removeLine(p, this.getPlayerName(p));
        }
    }

    @Override
    public void setText(String text) {
        this.setValues(text);
        for (TabPlayer p : this.parent.getPlayers()) {
            this.unregister(p);
            this.register(p);
        }
    }
}

