/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.sorting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import me.neznamy.tab.api.TabFeature;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.shared.ITabPlayer;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.layout.LayoutManager;
import me.neznamy.tab.shared.features.nametags.NameTag;
import me.neznamy.tab.shared.features.sorting.types.Groups;
import me.neznamy.tab.shared.features.sorting.types.Permissions;
import me.neznamy.tab.shared.features.sorting.types.Placeholder;
import me.neznamy.tab.shared.features.sorting.types.PlaceholderAtoZ;
import me.neznamy.tab.shared.features.sorting.types.PlaceholderHighToLow;
import me.neznamy.tab.shared.features.sorting.types.PlaceholderLowToHigh;
import me.neznamy.tab.shared.features.sorting.types.PlaceholderZtoA;
import me.neznamy.tab.shared.features.sorting.types.SortingType;

public class Sorting
extends TabFeature {
    private final NameTag nameTags;
    private final Map<String, BiFunction<Sorting, String, SortingType>> types = new LinkedHashMap<String, BiFunction<Sorting, String, SortingType>>();
    private final boolean caseSensitiveSorting = TAB.getInstance().getConfiguration().getConfig().getBoolean("scoreboard-teams.case-sensitive-sorting", true);
    private final SortingType[] usedSortingTypes;

    public Sorting(NameTag nameTags) {
        super("Team name refreshing", "Refreshing team name");
        this.nameTags = nameTags;
        this.types.put("GROUPS", Groups::new);
        this.types.put("PERMISSIONS", Permissions::new);
        this.types.put("PLACEHOLDER", Placeholder::new);
        this.types.put("PLACEHOLDER_A_TO_Z", PlaceholderAtoZ::new);
        this.types.put("PLACEHOLDER_Z_TO_A", PlaceholderZtoA::new);
        this.types.put("PLACEHOLDER_LOW_TO_HIGH", PlaceholderLowToHigh::new);
        this.types.put("PLACEHOLDER_HIGH_TO_LOW", PlaceholderHighToLow::new);
        this.usedSortingTypes = this.compile(TAB.getInstance().getConfiguration().getConfig().getStringList("scoreboard-teams.sorting-types", new ArrayList<String>()));
    }

    @Override
    public void refresh(TabPlayer p, boolean force) {
        if (this.nameTags != null && (this.nameTags.getForcedTeamName(p) != null || this.nameTags.hasTeamHandlingPaused(p))) {
            return;
        }
        String newName = this.getTeamName(p);
        if (!p.getTeamName().equals(newName)) {
            LayoutManager layout;
            if (this.nameTags != null) {
                this.nameTags.unregisterTeam(p);
            }
            if ((layout = (LayoutManager)TAB.getInstance().getFeatureManager().getFeature("layout")) != null) {
                layout.updateTeamName(p, newName);
            }
            ((ITabPlayer)p).setTeamName(newName);
            if (this.nameTags != null) {
                this.nameTags.registerTeam(p);
            }
        }
    }

    @Override
    public void load() {
        if (this.nameTags != null) {
            return;
        }
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            ((ITabPlayer)all).setTeamName(this.getTeamName(all));
        }
    }

    @Override
    public void onJoin(TabPlayer connectedPlayer) {
        if (this.nameTags != null) {
            return;
        }
        ((ITabPlayer)connectedPlayer).setTeamName(this.getTeamName(connectedPlayer));
    }

    private SortingType[] compile(List<String> options) {
        ArrayList<SortingType> list = new ArrayList<SortingType>();
        for (String element : options) {
            String[] arr = element.split(":");
            if (!this.types.containsKey(arr[0].toUpperCase())) {
                TAB.getInstance().getErrorManager().startupWarn("\"&e" + arr[0].toUpperCase() + "&c\" is not a valid sorting type element. Valid options are: &e" + this.types.keySet() + ".");
                continue;
            }
            list.add(this.types.get(arr[0].toUpperCase()).apply(this, arr.length == 1 ? "" : element.substring(arr[0].length() + 1)));
        }
        return list.toArray(new SortingType[0]);
    }

    public String getTeamName(TabPlayer p) {
        ((ITabPlayer)p).setTeamNameNote("");
        StringBuilder sb = new StringBuilder();
        for (SortingType type : this.usedSortingTypes) {
            sb.append(type.getChars((ITabPlayer)p));
        }
        if (sb.length() > 15) {
            sb.setLength(15);
        }
        return this.checkTeamName(p, sb, 65);
    }

    private String checkTeamName(TabPlayer p, StringBuilder currentName, int id) {
        String potentialTeamName = currentName.toString();
        if (!this.caseSensitiveSorting) {
            potentialTeamName = potentialTeamName.toLowerCase();
        }
        potentialTeamName = potentialTeamName + (char)id;
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            if (all == p || all.getTeamName() == null || !all.getTeamName().equals(potentialTeamName)) continue;
            return this.checkTeamName(p, currentName, id + 1);
        }
        return potentialTeamName;
    }

    public String typesToString() {
        return Arrays.stream(this.usedSortingTypes).map(Object::toString).collect(Collectors.joining(" then "));
    }
}

