/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.permission;

import java.util.Optional;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.shared.permission.PermissionPlugin;
import me.neznamy.tab.shared.placeholders.PrefixSuffixProvider;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.cacheddata.CachedMetaData;
import net.luckperms.api.model.user.User;
import net.luckperms.api.query.QueryOptions;

public class LuckPerms
implements PermissionPlugin,
PrefixSuffixProvider {
    private static final String UPDATE_MESSAGE = "Upgrade to LuckPerms 5";
    private final String version;

    public LuckPerms(String version) {
        this.version = version;
    }

    @Override
    public String getPrimaryGroup(TabPlayer p) {
        try {
            if (this.version.startsWith("4")) {
                return UPDATE_MESSAGE;
            }
            net.luckperms.api.LuckPerms api = LuckPermsProvider.get();
            User user = api.getUserManager().getUser(p.getUniqueId());
            if (user == null) {
                return "NONE";
            }
            return user.getPrimaryGroup();
        }
        catch (Exception e) {
            return "NONE";
        }
    }

    @Override
    public String getPrefix(TabPlayer p) {
        return this.getValue(p, true);
    }

    @Override
    public String getSuffix(TabPlayer p) {
        return this.getValue(p, false);
    }

    private String getValue(TabPlayer p, boolean prefix) {
        try {
            if (this.version.startsWith("4")) {
                return UPDATE_MESSAGE;
            }
            net.luckperms.api.LuckPerms api = LuckPermsProvider.get();
            User user = api.getUserManager().getUser(p.getUniqueId());
            if (user == null) {
                return "";
            }
            Optional options = LuckPermsProvider.get().getContextManager().getQueryOptions(user);
            if (!options.isPresent()) {
                return "";
            }
            CachedMetaData data = user.getCachedData().getMetaData((QueryOptions)options.get());
            String value = prefix ? data.getPrefix() : data.getSuffix();
            return value == null ? "" : value;
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getVersion() {
        return this.version;
    }
}

