/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.placeholders;

import java.util.ArrayList;
import java.util.List;
import me.neznamy.tab.api.chat.EnumChatFormat;
import me.neznamy.tab.api.chat.rgb.RGBUtils;
import me.neznamy.tab.shared.TAB;

public class Animation {
    private final String name;
    private final String[] messages;
    private final int interval;
    private final int refresh;
    private final String[] nestedPlaceholders;

    public Animation(String name, List<String> list, int interval) {
        this.name = name;
        this.messages = TAB.getInstance().getErrorManager().fixAnimationFrames(name, list).toArray(new String[0]);
        int refresh = this.interval = TAB.getInstance().getErrorManager().fixAnimationInterval(name, interval);
        ArrayList<String> nestedPlaceholders0 = new ArrayList<String>();
        for (int i = 0; i < this.messages.length; ++i) {
            this.messages[i] = RGBUtils.getInstance().applyFormats(this.messages[i], true);
            this.messages[i] = EnumChatFormat.color(this.messages[i]);
            nestedPlaceholders0.addAll(TAB.getInstance().getPlaceholderManager().detectPlaceholders(this.messages[i]));
        }
        for (String placeholder : nestedPlaceholders0) {
            int localRefresh;
            if (placeholder.startsWith("%animation:")) {
                String nestedAnimation = placeholder.substring(11, placeholder.length() - 1);
                localRefresh = TAB.getInstance().getConfiguration().getAnimationFile().hasConfigOption(nestedAnimation + ".change-interval") ? TAB.getInstance().getConfiguration().getAnimationFile().getInt(nestedAnimation + ".change-interval") : this.interval;
            } else {
                localRefresh = TAB.getInstance().getPlaceholderManager().getPlaceholder(placeholder).getRefresh();
            }
            if (localRefresh == -1 || localRefresh >= refresh) continue;
            refresh = localRefresh;
        }
        this.refresh = refresh;
        TAB.getInstance().getPlaceholderManager().addUsedPlaceholders(nestedPlaceholders0);
        this.nestedPlaceholders = nestedPlaceholders0.toArray(new String[0]);
    }

    public String getMessage() {
        return this.messages[TAB.getInstance().getPlaceholderManager().getLoopTime().get() % (this.messages.length * this.interval) / this.interval];
    }

    public String getName() {
        return this.name;
    }

    public int getRefresh() {
        return this.refresh;
    }

    public String[] getNestedPlaceholders() {
        return this.nestedPlaceholders;
    }
}

