/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.placeholders;

import java.util.HashMap;
import java.util.Map;
import me.neznamy.tab.api.chat.EnumChatFormat;

public class PlaceholderReplacementPattern {
    private final Map<String, String> replacements = new HashMap<String, String>();
    private final String[] numberIntervalKeys;
    private final Map<String, float[]> numberIntervals = new HashMap<String, float[]>();

    public PlaceholderReplacementPattern(Map<Object, Object> map) {
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            String key = String.valueOf(entry.getKey());
            String value = String.valueOf(entry.getValue());
            this.replacements.put(EnumChatFormat.color(key), EnumChatFormat.color(value));
            if ("true".equals(key)) {
                this.replacements.put("yes", value);
                continue;
            }
            if ("false".equals(key)) {
                this.replacements.put("no", value);
                continue;
            }
            if (!key.contains("-")) continue;
            try {
                this.numberIntervals.put(key, new float[]{Float.parseFloat(key.split("-")[0]), Float.parseFloat(key.split("-")[1])});
            }
            catch (NumberFormatException numberFormatException) {}
        }
        this.numberIntervalKeys = this.numberIntervals.keySet().toArray(new String[0]);
    }

    public String findReplacement(String output) {
        String replacement = this.findReplacement0(output);
        if (replacement == null) {
            return "";
        }
        if (replacement.contains("%value%")) {
            replacement = replacement.replace("%value%", output);
        }
        return replacement;
    }

    private String findReplacement0(String output) {
        if (this.replacements.isEmpty()) {
            return output;
        }
        if (this.replacements.containsKey(output)) {
            return this.replacements.get(output);
        }
        if (this.numberIntervalKeys.length > 0) {
            try {
                float value = Float.parseFloat(output.contains(",") ? output.replace(",", "") : output);
                for (String key : this.numberIntervalKeys) {
                    if (!(this.numberIntervals.get(key)[0] <= value) || !(value <= this.numberIntervals.get(key)[1])) continue;
                    return this.replacements.get(key);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.replacements.containsKey("else")) {
            return this.replacements.get("else");
        }
        return output;
    }
}

