/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.placeholders;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Function;
import me.neznamy.tab.api.TabFeature;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.placeholder.PlayerPlaceholder;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.placeholders.TabPlaceholder;

public class PlayerPlaceholderImpl
extends TabPlaceholder
implements PlayerPlaceholder {
    private static final String ERROR_VALUE = "ERROR";
    private final Function<TabPlayer, Object> function;
    private final WeakHashMap<TabPlayer, String> lastValues = new WeakHashMap();
    private final Set<TabPlayer> forceUpdate = Collections.newSetFromMap(new WeakHashMap());

    public PlayerPlaceholderImpl(String identifier, int refresh, Function<TabPlayer, Object> function) {
        super(identifier, refresh);
        if (identifier.startsWith("%rel_")) {
            throw new IllegalArgumentException("\"rel_\" is reserved for relational placeholder identifiers");
        }
        this.function = function;
    }

    public boolean update(TabPlayer p) {
        String newValue;
        Object output = this.request(p);
        if (output == null) {
            return false;
        }
        String obj = this.getReplacements().findReplacement(String.valueOf(output));
        String string = newValue = obj == null ? this.identifier : this.setPlaceholders(obj, p);
        if (this.identifier.equals(newValue) && !this.lastValues.containsKey(p)) {
            this.lastValues.put(p, this.identifier);
        }
        if (!this.lastValues.containsKey(p) || !ERROR_VALUE.equals(newValue) && !this.identifier.equals(newValue) && !this.lastValues.get(p).equals(newValue)) {
            this.lastValues.put(p, ERROR_VALUE.equals(newValue) ? this.identifier : newValue);
            return true;
        }
        if (this.forceUpdate.contains(p)) {
            this.forceUpdate.remove(p);
            return true;
        }
        return false;
    }

    @Override
    public void updateFromNested(TabPlayer player) {
        this.updateValue(player, this.request(player), true);
    }

    @Override
    public String getLastValue(TabPlayer p) {
        if (p == null) {
            return this.identifier;
        }
        if (!this.lastValues.containsKey(p)) {
            this.lastValues.put(p, this.getReplacements().findReplacement(this.identifier));
            this.update(p);
        }
        return this.lastValues.get(p);
    }

    @Override
    public Object request(TabPlayer p) {
        try {
            return this.function.apply(p);
        }
        catch (Throwable t) {
            TAB.getInstance().getErrorManager().placeholderError("Player placeholder " + this.identifier + " generated an error when setting for player " + p.getName(), t);
            return ERROR_VALUE;
        }
    }

    public Map<TabPlayer, String> getLastValues() {
        return this.lastValues;
    }

    public Set<TabPlayer> getForceUpdate() {
        return this.forceUpdate;
    }

    @Override
    public void updateValue(TabPlayer player, Object value) {
        this.updateValue(player, value, false);
    }

    private void updateValue(TabPlayer player, Object value, boolean force) {
        String s = this.getReplacements().findReplacement(String.valueOf(value));
        if (this.lastValues.containsKey(player) && this.lastValues.get(player).equals(s) && !force) {
            return;
        }
        this.lastValues.put(player, s);
        if (!player.isLoaded()) {
            return;
        }
        Set<TabFeature> usage = TAB.getInstance().getPlaceholderManager().getPlaceholderUsage().get(this.identifier);
        if (usage == null) {
            return;
        }
        for (TabFeature f : usage) {
            long time = System.nanoTime();
            f.refresh(player, false);
            TAB.getInstance().getCPUManager().addTime(f.getFeatureName(), f.getRefreshDisplayName(), System.nanoTime() - time);
        }
        this.parents.stream().map(identifier -> TAB.getInstance().getPlaceholderManager().getPlaceholder((String)identifier)).forEach(placeholder -> placeholder.updateFromNested(player));
    }
}

