/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.placeholders;

import java.util.Set;
import java.util.function.Supplier;
import me.neznamy.tab.api.TabFeature;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.placeholder.ServerPlaceholder;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.placeholders.TabPlaceholder;

public class ServerPlaceholderImpl
extends TabPlaceholder
implements ServerPlaceholder {
    private final Supplier<Object> supplier;
    private String lastValue;

    public ServerPlaceholderImpl(String identifier, int refresh, Supplier<Object> supplier) {
        super(identifier, refresh);
        if (identifier.startsWith("%rel_")) {
            throw new IllegalArgumentException("\"rel_\" is reserved for relational placeholder identifiers");
        }
        this.supplier = supplier;
        this.update();
    }

    public boolean update() {
        String newValue;
        String obj = this.getReplacements().findReplacement(String.valueOf(this.request()));
        String string = newValue = obj == null ? this.identifier : this.setPlaceholders(obj, null);
        if (this.identifier.equals(newValue) && this.lastValue == null) {
            this.lastValue = this.identifier;
        }
        if (!("ERROR".equals(newValue) || this.identifier.equals(newValue) || this.lastValue != null && this.lastValue.equals(newValue))) {
            this.lastValue = newValue;
            return true;
        }
        return false;
    }

    @Override
    public void updateFromNested(TabPlayer player) {
        this.updateValue(this.request(), true);
    }

    @Override
    public String getLastValue(TabPlayer p) {
        return this.lastValue;
    }

    @Override
    public Object request() {
        try {
            return this.supplier.get();
        }
        catch (Throwable t) {
            TAB.getInstance().getErrorManager().placeholderError("Server placeholder " + this.identifier + " generated an error", t);
            return "ERROR";
        }
    }

    @Override
    public void updateValue(Object value) {
        this.updateValue(value, false);
    }

    private void updateValue(Object value, boolean force) {
        String s = this.getReplacements().findReplacement(String.valueOf(value));
        if (s.equals(this.lastValue) && !force) {
            return;
        }
        this.lastValue = s;
        Set<TabFeature> usage = TAB.getInstance().getPlaceholderManager().getPlaceholderUsage().get(this.identifier);
        if (usage == null) {
            return;
        }
        for (TabPlayer player : TAB.getInstance().getOnlinePlayers()) {
            for (TabFeature f : usage) {
                long time = System.nanoTime();
                f.refresh(player, false);
                TAB.getInstance().getCPUManager().addTime(f.getFeatureName(), f.getRefreshDisplayName(), System.nanoTime() - time);
            }
        }
        this.parents.stream().map(identifier -> TAB.getInstance().getPlaceholderManager().getPlaceholder((String)identifier)).forEach(placeholder -> placeholder.updateFromNested(null));
    }
}

