/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.placeholders;

import java.util.ArrayList;
import java.util.List;
import me.neznamy.tab.api.TabAPI;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.placeholder.Placeholder;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.placeholders.PlaceholderReplacementPattern;

public abstract class TabPlaceholder
implements Placeholder {
    private static final String[] EMPTY_ARRAY = new String[0];
    private final int refresh;
    protected final String identifier;
    protected final PlaceholderReplacementPattern replacements;
    private boolean active;
    private boolean triggerMode;
    private Runnable onActivation;
    private Runnable onDisable;
    protected final List<String> parents = new ArrayList<String>();

    protected TabPlaceholder(String identifier, int refresh) {
        if (refresh % 50 != 0 && refresh != -1) {
            throw new IllegalArgumentException("Refresh interval must be divisible by 50");
        }
        if (!identifier.startsWith("%") || !identifier.endsWith("%")) {
            throw new IllegalArgumentException("Identifier must start and end with %");
        }
        this.identifier = identifier;
        this.refresh = refresh;
        this.replacements = new PlaceholderReplacementPattern(TAB.getInstance().getConfiguration().getConfig().getConfigurationSection("placeholder-output-replacements." + identifier));
        for (String nested : this.getNestedPlaceholders("")) {
            TAB.getInstance().getPlaceholderManager().getPlaceholder(nested).addParent(identifier);
        }
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public int getRefresh() {
        return this.refresh;
    }

    public String set(String s, TabPlayer p) {
        return this.replace(s, this.identifier, this.setPlaceholders(this.getLastValue(p), p));
    }

    public String[] getNestedPlaceholders(String output) {
        if (!output.contains("%")) {
            return EMPTY_ARRAY;
        }
        return TabAPI.getInstance().getPlaceholderManager().detectPlaceholders(output).toArray(EMPTY_ARRAY);
    }

    private String replace(String string, String original, String replacement) {
        if (!string.contains(original)) {
            return string;
        }
        if (string.equals(original)) {
            return replacement;
        }
        return string.replace(original, replacement);
    }

    protected String setPlaceholders(String text, TabPlayer p) {
        if (this.identifier.equals(text)) {
            return text;
        }
        String replaced = text;
        for (String s : this.getNestedPlaceholders(text)) {
            if (s.equals(this.identifier) || this.identifier.startsWith("%sync:") && ("%" + this.identifier.substring(6)).equals(s) || s.startsWith("%rel_")) continue;
            replaced = TAB.getInstance().getPlaceholderManager().getPlaceholder(s).set(replaced, p);
        }
        return replaced;
    }

    public PlaceholderReplacementPattern getReplacements() {
        return this.replacements;
    }

    @Override
    public void enableTriggerMode() {
        this.triggerMode = true;
    }

    @Override
    public void enableTriggerMode(Runnable onActivation, Runnable onDisable) {
        this.triggerMode = true;
        this.onActivation = onActivation;
        this.onDisable = onDisable;
        if (this.active && onActivation != null) {
            onActivation.run();
        }
    }

    public void markAsUsed() {
        if (this.active) {
            return;
        }
        this.active = true;
        if (this.onActivation != null) {
            this.onActivation.run();
        }
    }

    @Override
    public boolean isTriggerMode() {
        return this.triggerMode;
    }

    @Override
    public void unload() {
        if (this.onDisable != null && this.active) {
            this.onDisable.run();
        }
    }

    public abstract void updateFromNested(TabPlayer var1);

    public abstract String getLastValue(TabPlayer var1);

    public void addParent(String parent) {
        if (!this.parents.contains(parent)) {
            this.parents.add(parent);
        }
    }
}

