/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.placeholders.conditions;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.PlaceholderManagerImpl;
import me.neznamy.tab.shared.placeholders.TabPlaceholder;
import me.neznamy.tab.shared.placeholders.conditions.ConditionType;
import me.neznamy.tab.shared.placeholders.conditions.simple.ContainsCondition;
import me.neznamy.tab.shared.placeholders.conditions.simple.EqualsCondition;
import me.neznamy.tab.shared.placeholders.conditions.simple.LessThanCondition;
import me.neznamy.tab.shared.placeholders.conditions.simple.LessThanOrEqualsCondition;
import me.neznamy.tab.shared.placeholders.conditions.simple.MoreThanCondition;
import me.neznamy.tab.shared.placeholders.conditions.simple.MoreThanOrEqualsCondition;
import me.neznamy.tab.shared.placeholders.conditions.simple.NotEqualsCondition;
import me.neznamy.tab.shared.placeholders.conditions.simple.PermissionCondition;
import me.neznamy.tab.shared.placeholders.conditions.simple.SimpleCondition;

public class Condition {
    private static Map<String, Condition> conditions = new HashMap<String, Condition>();
    private static final Map<String, Function<String, SimpleCondition>> conditionTypes = new LinkedHashMap<String, Function<String, SimpleCondition>>();
    private final ConditionType type;
    private final String name;
    protected SimpleCondition[] subConditions;
    private final String yes;
    private final String no;
    private int refresh = 10000;

    protected Condition(ConditionType type, String name, List<String> conditions, String yes, String no) {
        this.type = type;
        this.name = name;
        this.yes = yes;
        this.no = no;
        if (conditions == null) {
            TAB.getInstance().getErrorManager().startupWarn("Condition \"" + name + "\" is missing \"conditions\" section.");
            return;
        }
        ArrayList<SimpleCondition> list = new ArrayList<SimpleCondition>();
        for (String line : conditions) {
            SimpleCondition condition = SimpleCondition.compile(line);
            if (condition != null) {
                list.add(condition);
                continue;
            }
            TAB.getInstance().getErrorManager().startupWarn("\"" + line + "\" is not a defined condition nor a condition pattern");
        }
        this.subConditions = list.toArray(new SimpleCondition[0]);
        PlaceholderManagerImpl pm = TAB.getInstance().getPlaceholderManager();
        ArrayList<String> placeholdersInConditions = new ArrayList<String>();
        for (String subCondition : conditions) {
            if (subCondition.startsWith("permission:")) {
                if (this.refresh <= 1000) continue;
                this.refresh = 1000;
                continue;
            }
            placeholdersInConditions.addAll(pm.detectPlaceholders(subCondition));
        }
        placeholdersInConditions.addAll(pm.detectPlaceholders(yes));
        placeholdersInConditions.addAll(pm.detectPlaceholders(no));
        for (String placeholder : placeholdersInConditions) {
            TabPlaceholder pl = TAB.getInstance().getPlaceholderManager().getPlaceholder(placeholder);
            if (pl.getRefresh() >= this.refresh) continue;
            if (pl.getRefresh() == -1) {
                if (this.refresh <= 500) continue;
                this.refresh = 500;
                continue;
            }
            this.refresh = pl.getRefresh();
        }
        pm.addUsedPlaceholders(placeholdersInConditions);
    }

    public int getRefresh() {
        return this.refresh;
    }

    public String getName() {
        return this.name;
    }

    public String getText(TabPlayer p) {
        return this.isMet(p) ? this.getYes() : this.getNo();
    }

    public boolean isMet(TabPlayer p) {
        if (this.type == ConditionType.AND) {
            for (SimpleCondition condition : this.subConditions) {
                if (condition.isMet(p)) continue;
                return false;
            }
            return true;
        }
        for (SimpleCondition condition : this.subConditions) {
            if (!condition.isMet(p)) continue;
            return true;
        }
        return false;
    }

    public static Condition compile(String name, List<String> conditions, String conditionType, String yes, String no) {
        ConditionType type;
        block2: {
            try {
                type = ConditionType.valueOf(conditionType);
            }
            catch (IllegalArgumentException e) {
                type = ConditionType.AND;
                if (conditions.size() <= 1) break block2;
                TAB.getInstance().getErrorManager().startupWarn("Invalid condition type: " + conditionType);
            }
        }
        return new Condition(type, name, conditions, yes, no);
    }

    public static Condition getCondition(String string) {
        if (string == null) {
            return null;
        }
        if (Condition.getConditions().containsKey(string)) {
            return Condition.getConditions().get(string);
        }
        Condition c = Condition.compile("AnonymousCondition[" + string + "]", Lists.newArrayList((Object[])string.split(";")), "AND", "true", "false");
        TAB.getInstance().getPlaceholderManager().registerPlayerPlaceholder("%condition:" + c.getName() + "%", c.getRefresh(), c::getText);
        return c;
    }

    public static Map<String, Condition> getConditions() {
        return conditions;
    }

    public static void setConditions(Map<String, Condition> conditions) {
        Condition.conditions = conditions;
    }

    public static Map<String, Function<String, SimpleCondition>> getConditionTypes() {
        return conditionTypes;
    }

    public String getYes() {
        return this.yes;
    }

    public String getNo() {
        return this.no;
    }

    static {
        conditionTypes.put("permission:", PermissionCondition::new);
        conditionTypes.put("<-", ContainsCondition::new);
        conditionTypes.put(">=", MoreThanOrEqualsCondition::new);
        conditionTypes.put(">", MoreThanCondition::new);
        conditionTypes.put("<=", LessThanOrEqualsCondition::new);
        conditionTypes.put("<", LessThanCondition::new);
        conditionTypes.put("!=", NotEqualsCondition::new);
        conditionTypes.put("=", EqualsCondition::new);
    }
}

