/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.placeholders.conditions.simple;

import java.util.Map;
import java.util.function.Function;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.chat.EnumChatFormat;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.placeholders.conditions.Condition;

public abstract class SimpleCondition {
    private String leftSide;
    private String[] leftSidePlaceholders;
    private String rightSide;
    private String[] rightSidePlaceholders;

    protected void setSides(String leftSide, String rightSide) {
        this.leftSide = leftSide;
        this.leftSidePlaceholders = TAB.getInstance().getPlaceholderManager().detectPlaceholders(leftSide).toArray(new String[0]);
        this.rightSide = rightSide;
        this.rightSidePlaceholders = TAB.getInstance().getPlaceholderManager().detectPlaceholders(rightSide).toArray(new String[0]);
    }

    public String parseLeftSide(TabPlayer p) {
        return this.parseSide(p, this.leftSide, this.leftSidePlaceholders);
    }

    public String parseRightSide(TabPlayer p) {
        return this.parseSide(p, this.rightSide, this.rightSidePlaceholders);
    }

    public String parseSide(TabPlayer p, String value, String[] placeholders) {
        String result = value;
        for (String identifier : placeholders) {
            result = TAB.getInstance().getPlaceholderManager().getPlaceholder(identifier).set(result.toString(), p);
        }
        return result == null ? "null" : EnumChatFormat.color(result.toString());
    }

    public abstract boolean isMet(TabPlayer var1);

    public static SimpleCondition compile(String line) {
        for (Map.Entry<String, Function<String, SimpleCondition>> entry : Condition.getConditionTypes().entrySet()) {
            if (!line.contains(entry.getKey())) continue;
            return entry.getValue().apply(line);
        }
        return null;
    }
}

