/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.proxy;

import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.shared.Platform;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.PlaceholderManagerImpl;
import me.neznamy.tab.shared.features.PluginMessageHandler;
import me.neznamy.tab.shared.features.bossbar.BossBarManagerImpl;
import me.neznamy.tab.shared.features.globalplayerlist.GlobalPlayerList;
import me.neznamy.tab.shared.features.nametags.NameTag;
import me.neznamy.tab.shared.placeholders.PlayerPlaceholderImpl;
import me.neznamy.tab.shared.placeholders.RelationalPlaceholderImpl;
import me.neznamy.tab.shared.placeholders.TabPlaceholder;
import me.neznamy.tab.shared.placeholders.UniversalPlaceholderRegistry;

public abstract class ProxyPlatform
implements Platform {
    protected final PluginMessageHandler plm;

    protected ProxyPlatform(PluginMessageHandler plm) {
        this.plm = plm;
    }

    @Override
    public void registerUnknownPlaceholder(String identifier) {
        TabPlaceholder p;
        PlaceholderManagerImpl pl = TAB.getInstance().getPlaceholderManager();
        if (identifier.startsWith("%rel_")) {
            p = new RelationalPlaceholderImpl(identifier, pl.getRelationalRefresh(identifier), (viewer, target) -> "");
        } else {
            int refresh = pl.getPlayerPlaceholderRefreshIntervals().getOrDefault(identifier, pl.getServerPlaceholderRefreshIntervals().getOrDefault(identifier, pl.getDefaultRefresh()));
            p = new PlayerPlaceholderImpl(identifier, refresh, null){

                @Override
                public String request(TabPlayer p) {
                    ProxyPlatform.this.plm.requestPlaceholder(p, this.identifier);
                    return null;
                }
            };
        }
        pl.registerPlaceholder(p);
    }

    @Override
    public void loadFeatures() {
        TAB tab = TAB.getInstance();
        new UniversalPlaceholderRegistry().registerPlaceholders(tab.getPlaceholderManager());
        if (tab.getConfiguration().getConfig().getBoolean("scoreboard-teams.enabled", true)) {
            tab.getFeatureManager().registerFeature("NameTag16", new NameTag());
        }
        tab.loadUniversalFeatures();
        if (tab.getConfiguration().getConfig().getBoolean("bossbar.enabled", false)) {
            tab.getFeatureManager().registerFeature("BossBar", new BossBarManagerImpl());
        }
        if (tab.getConfiguration().getConfig().getBoolean("global-playerlist.enabled", false)) {
            tab.getFeatureManager().registerFeature("GlobalPlayerList", new GlobalPlayerList());
        }
    }

    @Override
    public String getConfigName() {
        return "proxyconfig.yml";
    }

    public PluginMessageHandler getPluginMessageHandler() {
        return this.plm;
    }
}

