/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.proxy;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.neznamy.tab.shared.ITabPlayer;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.PluginMessageHandler;
import me.neznamy.tab.shared.proxy.ProxyPlatform;

public abstract class ProxyTabPlayer
extends ITabPlayer {
    private Map<String, String> attributes = new HashMap<String, String>();
    private final Map<String, Long> cooldowns = new HashMap<String, Long>();

    protected ProxyTabPlayer(Object player, UUID uniqueId, String name, String server) {
        super(player, uniqueId, name, server, "N/A");
        this.getPluginMessageHandler().requestAttribute(this, "world");
    }

    @Override
    public boolean isVanished() {
        return Boolean.parseBoolean(this.getAttribute("vanished", false));
    }

    @Override
    public boolean isDisguised() {
        return Boolean.parseBoolean(this.getAttribute("disguised", false));
    }

    @Override
    public boolean hasInvisibilityPotion() {
        return Boolean.parseBoolean(this.getAttribute("invisible", false));
    }

    public String getAttribute(String name, Object def) {
        if (!this.cooldowns.containsKey(name) || System.currentTimeMillis() - this.cooldowns.get(name) > 1000L) {
            this.cooldowns.put(name, System.currentTimeMillis());
            this.getPluginMessageHandler().requestAttribute(this, name);
        }
        return this.getAttributes().getOrDefault(name, def.toString());
    }

    @Override
    public boolean hasPermission(String permission) {
        if (TAB.getInstance().getConfiguration().isBukkitPermissions()) {
            String merge = "hasPermission:" + permission;
            this.getPluginMessageHandler().requestAttribute(this, merge);
            return Boolean.parseBoolean(this.getAttributes().getOrDefault(merge, "false"));
        }
        return this.hasPermission0(permission);
    }

    public void setAttribute(String attribute, String value) {
        this.getAttributes().put(attribute, value);
    }

    public PluginMessageHandler getPluginMessageHandler() {
        return ((ProxyPlatform)TAB.getInstance().getPlatform()).getPluginMessageHandler();
    }

    private Map<String, String> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        return this.attributes;
    }

    public abstract boolean hasPermission0(String var1);
}

