/*
 * Decompiled with CFR 0.152.
 */
package com.andrei1058.bedwars.teamselector.teamselector;

import com.andrei1058.bedwars.api.arena.IArena;
import com.andrei1058.bedwars.api.arena.team.ITeam;
import com.andrei1058.bedwars.api.arena.team.ITeamAssigner;
import com.andrei1058.bedwars.api.events.gameplay.TeamAssignEvent;
import com.andrei1058.bedwars.teamselector.Main;
import com.andrei1058.bedwars.teamselector.teamselector.ArenaPreferences;
import com.andrei1058.bedwars.teamselector.teamselector.PlayerGroup;
import com.andrei1058.bedwars.teamselector.teamselector.TeamManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class TeamSelectorAssigner
implements ITeamAssigner {
    private final LinkedList<PlayerGroup> playerGroups = new LinkedList();
    private final List<UUID> skippedFromPartyCheck = new ArrayList<UUID>();
    private final List<UUID> playersAddedToATeam = new ArrayList<UUID>();
    private final LinkedList<ITeam> teams = new LinkedList();

    public void assignTeams(IArena arena) {
        PlayerGroup playerGroup;
        this.teams.addAll(arena.getTeams());
        for (Player player : arena.getPlayers()) {
            if (this.skippedFromPartyCheck.contains(player.getUniqueId()) || !Main.bw.getPartyUtil().isOwner(player)) continue;
            LinkedList<Player> partyMembers = new LinkedList<Player>();
            for (Player inParty : Main.bw.getPartyUtil().getMembers(player)) {
                if (!arena.isPlayer(inParty)) continue;
                partyMembers.add(inParty);
                this.skippedFromPartyCheck.add(inParty.getUniqueId());
            }
            if (!partyMembers.contains(player)) {
                partyMembers.add(player);
                this.skippedFromPartyCheck.add(player.getUniqueId());
            }
            if (partyMembers.size() < 2) continue;
            playerGroup = null;
            do {
                if (playerGroup == null || playerGroup.getMembers().size() == arena.getMaxInTeam()) {
                    playerGroup = new PlayerGroup(arena, null);
                    this.playerGroups.add(playerGroup);
                }
                Player toBeAdded = (Player)partyMembers.pollFirst();
                playerGroup.addPlayer(toBeAdded);
            } while (!partyMembers.isEmpty());
        }
        ArenaPreferences registeredPreference = TeamManager.getInstance().getArena(arena);
        for (ITeam preference : registeredPreference.getSelections().values().stream().distinct().collect(Collectors.toList())) {
            playerGroup = new PlayerGroup(arena, preference);
            for (Player teamSelector : registeredPreference.getMembers(preference)) {
                playerGroup.addPlayer(teamSelector);
            }
            this.playerGroups.add(playerGroup);
        }
        Collections.sort(this.playerGroups);
        if (!registeredPreference.getSelections().isEmpty()) {
            this.teams.sort(Comparator.comparingInt(o -> registeredPreference.getMembers((ITeam)o).size()));
        }
        for (PlayerGroup playerGroup2 : this.playerGroups) {
            if (playerGroup2.getMembers().isEmpty()) continue;
            if (playerGroup2.getPreference() == null) {
                ITeam targetTeam = null;
                for (ITeam team : this.teams) {
                    if (arena.getMaxInTeam() - team.getMembers().size() < playerGroup2.getMembers().size()) continue;
                    targetTeam = team;
                    break;
                }
                if (targetTeam == null) continue;
                for (Player player : playerGroup2.getMembers()) {
                    targetTeam.addPlayers(new Player[]{player});
                    TeamAssignEvent teamAssignEvent = new TeamAssignEvent(player, targetTeam, arena);
                    Bukkit.getPluginManager().callEvent((Event)teamAssignEvent);
                    this.playersAddedToATeam.add(player.getUniqueId());
                }
                if (targetTeam.getMembers().size() != arena.getMaxInTeam()) continue;
                this.teams.remove(targetTeam);
                continue;
            }
            for (Player player : playerGroup2.getMembers()) {
                if (playerGroup2.getPreference().getMembers().size() >= arena.getMaxInTeam()) continue;
                playerGroup2.getPreference().addPlayers(new Player[]{player});
                TeamAssignEvent teamAssignEvent = new TeamAssignEvent(player, playerGroup2.getPreference(), arena);
                Bukkit.getPluginManager().callEvent((Event)teamAssignEvent);
                this.playersAddedToATeam.add(player.getUniqueId());
            }
            if (playerGroup2.getPreference().getMembers().size() != arena.getMaxInTeam()) continue;
            this.teams.remove(playerGroup2.getPreference());
        }
        for (Player player : arena.getPlayers()) {
            if (this.playersAddedToATeam.contains(player.getUniqueId())) continue;
            boolean added = false;
            for (ITeam team : this.teams) {
                if (team.getMembers().size() >= arena.getMaxInTeam()) continue;
                team.addPlayers(new Player[]{player});
                added = true;
                break;
            }
            if (added) continue;
            player.kickPlayer("That was unexpected: you haven't been assigned to a team!");
        }
        this.playerGroups.clear();
        this.skippedFromPartyCheck.clear();
        this.playersAddedToATeam.clear();
        this.teams.clear();
    }
}

