/*
 * Decompiled with CFR 0.152.
 */
package me.mherzaqaryan.sponge;

import com.andrei1058.bedwars.api.BedWars;
import java.util.logging.Level;
import me.mherzaqaryan.sponge.listeners.SpongePlaceListener;
import me.mherzaqaryan.sponge.metrics.Metrics;
import me.mherzaqaryan.sponge.particle.ParticleSupport;
import me.mherzaqaryan.sponge.particle.versions.Newer;
import me.mherzaqaryan.sponge.particle.versions.Older;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Sponge
extends JavaPlugin {
    private static Sponge instance;
    private static BedWars bedWars;
    private static ParticleSupport particleSupport;
    private static String splash;
    private static String woodClick;
    private static final String version;

    public void onEnable() {
        long start = System.currentTimeMillis();
        instance = this;
        if (!this.setupBedwars()) {
            return;
        }
        if (!this.setupParticle()) {
            return;
        }
        bedWars = (BedWars)Bukkit.getServicesManager().getRegistration(BedWars.class).getProvider();
        new Metrics(this, 11788);
        Bukkit.getPluginManager().registerEvents((Listener)new SpongePlaceListener(), (Plugin)this);
        splash = bedWars.getForCurrentVersion("SPLASH", "ENTITY_PLAYER_SPLASH", "ENTITY_PLAYER_SPLASH");
        woodClick = bedWars.getForCurrentVersion("WOOD_CLICK", "BLOCK_WOOD_BUTTON_CLICK_ON", "BLOCK_WOODEN_BUTTON_CLICK_ON");
        this.getLogger().log(Level.INFO, "Successfully loaded in " + (System.currentTimeMillis() - start) + "ms");
    }

    public void onDisable() {
        Bukkit.getScheduler().cancelTasks((Plugin)this);
    }

    private boolean setupBedwars() {
        if (Bukkit.getPluginManager().isPluginEnabled("BedWars1058")) {
            return true;
        }
        this.getLogger().severe("BedWars1058 was not found. Disabling...");
        this.setEnabled(false);
        return false;
    }

    private boolean setupParticle() {
        boolean supported = true;
        switch (version) {
            case "v1_8_R2": 
            case "v1_8_R1": {
                supported = false;
                break;
            }
            case "v1_8_R3": {
                particleSupport = new Older();
                break;
            }
            default: {
                particleSupport = new Newer();
            }
        }
        if (!supported) {
            this.getLogger().severe("Your server version is not supported!");
            this.setEnabled(false);
        }
        return supported;
    }

    public static Sponge getInstance() {
        return instance;
    }

    public static BedWars getBedWars() {
        return bedWars;
    }

    public static ParticleSupport getParticleSupport() {
        return particleSupport;
    }

    public static String getSplash() {
        return splash;
    }

    public static String getWoodClick() {
        return woodClick;
    }

    public static String getVersion() {
        return version;
    }

    static {
        version = Bukkit.getServer().getClass().getPackage().getName().substring(23);
    }
}

