/*
 * Decompiled with CFR 0.152.
 */
package me.mherzaqaryan.sponge.tasks;

import java.util.ArrayList;
import java.util.List;
import me.mherzaqaryan.sponge.Sponge;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.scheduler.BukkitRunnable;

public class SpongeAnimationTask
extends BukkitRunnable {
    private final Block block;
    private final Location loc;
    private int radius = 1;
    private int pitch = 17;

    public SpongeAnimationTask(Block block) {
        this.block = block;
        this.loc = block.getLocation();
    }

    public void run() {
        if (this.radius > 4) {
            this.cancel();
            this.block.setType(Material.AIR);
            this.loc.getWorld().playSound(this.loc, Sound.valueOf((String)Sponge.getSplash()), 1.0f, 1.0f);
            return;
        }
        this.getParticles(this.loc, this.radius).forEach(loc -> Sponge.getParticleSupport().play((Location)loc));
        this.loc.getWorld().playSound(this.loc, Sound.valueOf((String)Sponge.getWoodClick()), 1.0f, (float)this.pitch / 10.0f);
        ++this.radius;
        ++this.pitch;
    }

    public List<Location> getParticles(Location loc, int radius) {
        ArrayList<Location> result = new ArrayList<Location>();
        Block start = loc.getWorld().getBlockAt(loc);
        int iterations = radius * 2 + 1;
        ArrayList<Block> blocks = new ArrayList<Block>(iterations * iterations * iterations);
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    blocks.add(start.getRelative(x, y, z));
                }
            }
        }
        blocks.stream().filter(b -> b.getType().equals((Object)Material.AIR)).forEach(b -> result.add(b.getLocation()));
        return result;
    }
}

