/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.api;

import net.skinsrestorer.api.PlayerWrapper;
import net.skinsrestorer.api.exception.SkinRequestException;
import net.skinsrestorer.api.interfaces.IMineSkinAPI;
import net.skinsrestorer.api.interfaces.IMojangAPI;
import net.skinsrestorer.api.interfaces.ISkinStorage;
import net.skinsrestorer.api.interfaces.IWrapperFactory;
import net.skinsrestorer.api.property.IProperty;

public abstract class SkinsRestorerAPI {
    private static SkinsRestorerAPI api;
    private final IMojangAPI mojangAPI;
    private final IMineSkinAPI mineSkinAPI;
    private final ISkinStorage skinStorage;
    private final IWrapperFactory wrapperFactory;

    protected SkinsRestorerAPI(IMojangAPI mojangAPI, IMineSkinAPI mineSkinAPI, ISkinStorage skinStorage, IWrapperFactory wrapperFactory) {
        if (api == null) {
            SkinsRestorerAPI.setInstance(this);
        }
        this.mojangAPI = mojangAPI;
        this.mineSkinAPI = mineSkinAPI;
        this.skinStorage = skinStorage;
        this.wrapperFactory = wrapperFactory;
    }

    private static void setInstance(SkinsRestorerAPI api) {
        if (SkinsRestorerAPI.api == null) {
            SkinsRestorerAPI.api = api;
        }
    }

    public IProperty getProfile(String uuid) {
        return this.mojangAPI.getProfile(uuid).orElse(null);
    }

    public String getSkinName(String playerName) {
        return this.skinStorage.getSkinName(playerName).orElse(null);
    }

    public boolean hasSkin(String playerName) {
        return this.getSkinName(playerName) != null;
    }

    public void setSkinName(String playerName, String skinName) {
        this.skinStorage.setSkinName(playerName, skinName);
    }

    public IProperty getSkinData(String skinName) {
        return this.skinStorage.getSkinData(skinName).orElse(null);
    }

    public void setSkin(String playerName, String skinName) throws SkinRequestException {
        this.setSkinName(playerName, skinName);
        this.skinStorage.getSkinForPlayer(skinName);
    }

    public void removeSkin(String playerName) {
        this.skinStorage.removeSkin(playerName);
    }

    public abstract void applySkin(PlayerWrapper var1) throws SkinRequestException;

    public abstract void applySkin(PlayerWrapper var1, String var2) throws SkinRequestException;

    public abstract void applySkin(PlayerWrapper var1, IProperty var2);

    public static SkinsRestorerAPI getApi() {
        return api;
    }

    protected IWrapperFactory getWrapperFactory() {
        return this.wrapperFactory;
    }
}

