/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.api.reflection.access;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.skinsrestorer.api.reflection.access.IAccess;
import net.skinsrestorer.api.reflection.reflect.DuckReflect;

public class DefaultImpl
implements IAccess {
    protected DuckReflect _reflect;
    private boolean _canGetValue = true;
    private boolean _canSetValue = true;
    private boolean _canSetFieldModifiers = false;
    private boolean _canSetMethodModifiers = false;
    private boolean _canGetNewInstance = true;
    private boolean _lazy;
    private Field _fieldModifiers = null;
    private Field _methodModifiers = null;

    public DefaultImpl(DuckReflect reflect, boolean canSetModifiers, boolean lazy) {
        this._reflect = reflect;
        this._lazy = canSetModifiers & lazy;
        if (canSetModifiers & !this._lazy) {
            this.changeSetFieldModifiers(true);
            this.changeSetMethodModifiers(true);
        }
    }

    public DefaultImpl(DuckReflect reflect, boolean canSetModifiers) {
        this(reflect, canSetModifiers, true);
    }

    @Override
    public Object getValue(Field target, Object obj) {
        if (!this._canGetValue) {
            return null;
        }
        return this._reflect.getValue(target, obj);
    }

    @Override
    public boolean setValue(Field target, Object obj, Object value) {
        if (!this._canSetValue) {
            return false;
        }
        return this._reflect.setValue(target, obj, value);
    }

    @Override
    public boolean setModifiers(Field target, int mod) {
        if (!this._canSetFieldModifiers) {
            if (this._lazy) {
                this.changeSetFieldModifiers(true);
                this.changeSetMethodModifiers(true);
                this._lazy = false;
                this._reflect.reset();
            } else {
                return false;
            }
        }
        return this._reflect.setValue(this._fieldModifiers, target, (Object)mod);
    }

    @Override
    public boolean setModifiers(Method target, int mod) {
        if (!this._canSetMethodModifiers) {
            if (this._lazy) {
                this.changeSetFieldModifiers(true);
                this.changeSetMethodModifiers(true);
                this._lazy = false;
                this._reflect.reset();
            } else {
                return false;
            }
        }
        return this._reflect.setValue(this._methodModifiers, target, (Object)mod);
    }

    @Override
    public Object getNewInstance(Constructor<?> target, Object ... args) {
        if (!this._canGetNewInstance) {
            return null;
        }
        return this._reflect.newInstance(target, args);
    }

    @Override
    public boolean changeGetValue(boolean enable) {
        this._canGetValue = enable;
        return true;
    }

    @Override
    public boolean changeSetValue(boolean enable) {
        this._canSetValue = enable;
        return true;
    }

    @Override
    public boolean changeSetFieldModifiers(boolean enable) {
        if (enable) {
            if (this._fieldModifiers == null) {
                this._fieldModifiers = this._reflect.getField(Field.class, "modifiers");
            }
            this._canSetFieldModifiers = this._fieldModifiers != null;
            return this._canSetFieldModifiers;
        }
        this._canSetFieldModifiers = false;
        return true;
    }

    @Override
    public boolean changeSetMethodModifiers(boolean enable) {
        if (enable) {
            if (this._methodModifiers == null) {
                this._methodModifiers = this._reflect.getField(Method.class, "modifiers");
            }
            this._canSetMethodModifiers = this._methodModifiers != null;
            return this._canSetMethodModifiers;
        }
        this._canSetMethodModifiers = false;
        return true;
    }

    @Override
    public boolean changeGetNewInstance(boolean enable) {
        this._canGetNewInstance = enable;
        return true;
    }
}

