/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.api.reflection.access;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.skinsrestorer.api.reflection.access.IAccess;
import net.skinsrestorer.api.reflection.reflect.DuckReflect;

public class UnsafeImpl
implements IAccess {
    protected static final int _FIELD_OFFSET = 24;
    protected static final int _METHOD_OFFSET = 36;
    protected DuckReflect _reflect;
    private boolean _canGetValue = false;
    private boolean _canSetValue = false;
    private boolean _canSetFieldModifiers = false;
    private boolean _canSetMethodModifiers = false;
    private boolean _canPrepareField = false;
    private boolean _canAccessObject = false;
    private boolean _canSetModifiers = false;
    private boolean _classExists = false;
    private boolean _instanceExists = false;
    private Class<?> _unsafeClass = null;
    private Object _unsafe = null;
    private Method _staticFieldBase = null;
    private Method _staticFieldOffset = null;
    private Method _objectFieldOffset = null;
    private Method _getObject = null;
    private Method _putObject = null;
    private Method _getAndSetInt = null;

    public UnsafeImpl(DuckReflect reflect, boolean canAccessObject, boolean canSetModifiers) {
        this._reflect = reflect;
        if (canAccessObject) {
            this.changeGetValue(true);
            this.changeSetValue(true);
        }
        if (canSetModifiers) {
            this.changeSetFieldModifiers(true);
            this.changeSetMethodModifiers(true);
        }
    }

    private void setClass() {
        this._unsafeClass = this._reflect.getClass("sun.misc.Unsafe");
        this._classExists = this._unsafeClass != null;
    }

    private void setInstance() {
        if (!this._classExists) {
            this.setClass();
        }
        if (this._classExists) {
            this._unsafe = this._reflect.newInstance(this._unsafeClass);
            if (this._unsafe == null) {
                this._unsafe = this._reflect.getValue(this._unsafeClass, "theUnsafe");
            }
            this._instanceExists = this._unsafe != null;
        }
    }

    private void setMethods(boolean canAccessObject, boolean canSetModifiers) {
        if (!this._instanceExists) {
            this.setInstance();
        }
        if (this._instanceExists) {
            if (canAccessObject) {
                if (!this._canPrepareField) {
                    this._staticFieldBase = this._reflect.getMethod(this._unsafeClass, "staticFieldBase", Field.class);
                    this._staticFieldOffset = this._reflect.getMethod(this._unsafeClass, "staticFieldOffset", Field.class);
                    this._objectFieldOffset = this._reflect.getMethod(this._unsafeClass, "objectFieldOffset", Field.class);
                    this._canPrepareField = this._staticFieldBase != null & this._staticFieldOffset != null & this._objectFieldOffset != null;
                }
                if (this._canPrepareField) {
                    this._getObject = this._reflect.getMethod(this._unsafeClass, "getObject", Object.class, Long.TYPE);
                    this._putObject = this._reflect.getMethod(this._unsafeClass, "putObject", Object.class, Long.TYPE, Object.class);
                    this._canAccessObject = this._getObject != null & this._putObject != null;
                }
            }
            if (canSetModifiers) {
                this._getAndSetInt = this._reflect.getMethod(this._unsafeClass, "getAndSetInt", Object.class, Long.TYPE, Integer.TYPE);
                this._canSetModifiers = this._getAndSetInt != null;
            }
        }
    }

    private Object getFieldBase(Field target, Object obj, boolean isStatic) {
        if (!isStatic) {
            return obj;
        }
        return this._reflect.call(this._staticFieldBase, this._unsafe, target);
    }

    private Long getFieldOffset(Field target, boolean isStatic) {
        if (isStatic) {
            return (Long)this._reflect.call(this._staticFieldOffset, this._unsafe, target);
        }
        return (Long)this._reflect.call(this._objectFieldOffset, this._unsafe, target);
    }

    @Override
    public Object getValue(Field target, Object obj) {
        if (!this._canGetValue | target == null) {
            return null;
        }
        Boolean isStatic = Modifier.isStatic(target.getModifiers());
        Object base = this.getFieldBase(target, obj, isStatic);
        Long offset = this.getFieldOffset(target, isStatic);
        if (base == null || !base.getClass().getName().equals("<unknown>")) {
            return this._reflect.call(this._getObject, this._unsafe, base, offset);
        }
        return null;
    }

    @Override
    public boolean setValue(Field target, Object obj, Object value) {
        if (!this._canSetValue | target == null) {
            return false;
        }
        Boolean isStatic = Modifier.isStatic(target.getModifiers());
        Object base = this.getFieldBase(target, obj, isStatic);
        long offset = this.getFieldOffset(target, isStatic);
        if (base == null || !base.getClass().getName().equals("<unknown>")) {
            return this._reflect.exec(this._putObject, this._unsafe, base, offset, value);
        }
        return false;
    }

    private boolean setModifiers(Member target, long offset, int mod) {
        return this._reflect.exec(this._getAndSetInt, this._unsafe, target, offset, mod);
    }

    @Override
    public boolean setModifiers(Field target, int mod) {
        if (!this._canSetFieldModifiers) {
            return false;
        }
        return this.setModifiers(target, 24L, mod);
    }

    @Override
    public boolean setModifiers(Method target, int mod) {
        if (!this._canSetMethodModifiers) {
            return false;
        }
        return this.setModifiers(target, 36L, mod);
    }

    @Override
    public Object getNewInstance(Constructor<?> target, Object ... args) {
        return null;
    }

    @Override
    public boolean changeGetValue(boolean enable) {
        if (enable) {
            if (!this._canAccessObject) {
                this.setMethods(true, false);
            }
            this._canGetValue = this._canAccessObject;
            return this._canGetValue;
        }
        this._canGetValue = false;
        return true;
    }

    @Override
    public boolean changeSetValue(boolean enable) {
        if (enable) {
            if (!this._canAccessObject) {
                this.setMethods(true, false);
            }
            this._canSetValue = this._canAccessObject;
            return this._canSetValue;
        }
        this._canSetValue = false;
        return true;
    }

    @Override
    public boolean changeSetFieldModifiers(boolean enable) {
        if (enable) {
            if (!this._canSetModifiers) {
                this.setMethods(false, true);
            }
            this._canSetFieldModifiers = this._canSetModifiers;
            return this._canSetFieldModifiers;
        }
        this._canSetFieldModifiers = false;
        return true;
    }

    @Override
    public boolean changeSetMethodModifiers(boolean enable) {
        if (enable) {
            if (!this._canSetModifiers) {
                this.setMethods(false, true);
            }
            this._canSetMethodModifiers = this._canSetModifiers;
            return this._canSetMethodModifiers;
        }
        this._canSetMethodModifiers = false;
        return true;
    }

    @Override
    public boolean changeGetNewInstance(boolean enable) {
        return false;
    }
}

