/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.api.reflection.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.skinsrestorer.api.reflection.reflect.DuckHandler;
import net.skinsrestorer.api.reflection.reflect.IDuckHandler;

public class DuckReflect {
    protected IDuckHandler _handler;
    private Method _setAccessible;

    public DuckReflect(IDuckHandler handler) {
        this._handler = handler;
        try {
            this._setAccessible = AccessibleObject.class.getMethod("setAccessible", Boolean.TYPE);
            this._setAccessible.setAccessible(true);
        }
        catch (Exception ex) {
            this.process(ex);
        }
    }

    public DuckReflect(boolean debug) {
        this(new DuckHandler(debug));
    }

    public void reset() {
        this._handler.reset();
    }

    public boolean check() {
        return this._handler.check();
    }

    public void process(Throwable ex) {
        this._handler.process(ex);
    }

    public boolean setAccessible(AccessibleObject target) {
        if (this._setAccessible == null || target == null) {
            return false;
        }
        try {
            this._setAccessible.invoke((Object)target, true);
            return true;
        }
        catch (Throwable ex) {
            this.process(ex);
            return false;
        }
    }

    public boolean replaceMethod(Method setAccessible) {
        if (setAccessible == null) {
            return false;
        }
        this._setAccessible = setAccessible;
        return true;
    }

    public Class<?> getClass(Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            return obj.getClass();
        }
        catch (Throwable ex) {
            this.process(ex);
            return null;
        }
    }

    public Class<?> getClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (Throwable ex) {
            this.process(ex);
            return null;
        }
    }

    public <T> Constructor<T> getConstructor(Class<T> type, boolean accessible, Class<?> ... argTypes) {
        if (type == null) {
            return null;
        }
        try {
            Constructor<T> constructor = type.getDeclaredConstructor(argTypes);
            if (accessible) {
                this.setAccessible(constructor);
            }
            return constructor;
        }
        catch (Throwable ex) {
            this.process(ex);
            return null;
        }
    }

    public <T> Constructor<T> getConstructor(Class<T> type, Class<?> ... argTypes) {
        return this.getConstructor(type, true, argTypes);
    }

    public <T> T newInstance(Constructor<T> target, Object ... args) {
        if (target == null) {
            return null;
        }
        try {
            return target.newInstance(args);
        }
        catch (Throwable ex) {
            this.process(ex);
            return null;
        }
    }

    public <T> T newInstance(Class<T> type) {
        return this.newInstance(this.getConstructor(type, new Class[]{null}), new Object[]{null});
    }

    public Field getField(Class<?> type, boolean accessible, String name) {
        if (type == null) {
            return null;
        }
        try {
            Field field = type.getDeclaredField(name);
            if (accessible) {
                this.setAccessible(field);
            }
            return field;
        }
        catch (Throwable ex) {
            this.process(ex);
            return null;
        }
    }

    public Field getField(Class<?> type, String name) {
        return this.getField(type, true, name);
    }

    public Method getMethod(Class<?> type, String name, boolean accessible, Class<?> ... argTypes) {
        if (type == null) {
            return null;
        }
        try {
            Method method = type.getDeclaredMethod(name, argTypes);
            if (accessible) {
                this.setAccessible(method);
            }
            return method;
        }
        catch (Throwable ex) {
            this.process(ex);
            return null;
        }
    }

    public Method getMethod(Class<?> type, String name, Class<?> ... argTypes) {
        return this.getMethod(type, name, true, argTypes);
    }

    public Object getValue(Field target, Object obj) {
        if (target == null) {
            return null;
        }
        try {
            return target.get(obj);
        }
        catch (Throwable ex) {
            this.process(ex);
            return null;
        }
    }

    public Object getValue(Field target) {
        return this.getValue(target, null);
    }

    public Object getValue(Class<?> type, String name, Object obj) {
        return this.getValue(this.getField(type, name), obj);
    }

    public Object getValue(Class<?> type, String name) {
        return this.getValue(type, name, null);
    }

    public boolean setValue(Field target, Object obj, Object value) {
        if (target == null) {
            return false;
        }
        try {
            target.set(obj, value);
            return true;
        }
        catch (Throwable ex) {
            this.process(ex);
            return false;
        }
    }

    public boolean setValue(Field target, Object value) {
        return this.setValue(target, null, value);
    }

    public boolean setValue(Class<?> type, String name, Object obj, Object value) {
        return this.setValue(this.getField(type, name), obj, value);
    }

    public boolean setValue(Class<?> type, String name, Object value) {
        return this.setValue(type, name, null, value);
    }

    public Object call(Method target, Object obj, Object ... argValues) {
        if (target == null) {
            return null;
        }
        try {
            return target.invoke(obj, argValues);
        }
        catch (Throwable ex) {
            this.process(ex);
            return null;
        }
    }

    public Object call(Class<?> type, String name, Class<?>[] argTypes, Object obj, Object ... argValues) {
        return this.call(this.getMethod(type, name, argTypes), obj, argValues);
    }

    public Object call(Class<?> type, String name, Object obj) {
        return this.call(type, name, null, obj, new Object[0]);
    }

    public Object call(Class<?> type, String name) {
        return this.call(type, name, null);
    }

    public boolean exec(Method target, Object obj, Object ... argValues) {
        if (target == null) {
            return false;
        }
        try {
            target.invoke(obj, argValues);
            return true;
        }
        catch (Throwable ex) {
            this.process(ex);
            return false;
        }
    }
}

