/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.api.serverinfo;

import java.lang.reflect.InvocationTargetException;
import net.skinsrestorer.shadow.jbannotations.Nullable;

public class ServerVersion {
    private final int major;
    private final int minor;
    private final int patch;

    @Nullable
    public static String getNMSVersion() {
        try {
            String serverPackage = Class.forName("org.bukkit.Bukkit").getMethod("getServer", new Class[0]).invoke(null, new Object[0]).getClass().getPackage().getName();
            return serverPackage.substring(serverPackage.lastIndexOf(46) + 1);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException ignored) {
            return null;
        }
    }

    public String getFormatted() {
        return this.major + "." + this.minor + "." + this.patch;
    }

    public boolean isNewer(ServerVersion version2) {
        if (this.equals(version2)) {
            return false;
        }
        if (version2.major > this.major) {
            return false;
        }
        if (version2.major < this.major) {
            return true;
        }
        if (version2.minor > this.minor) {
            return false;
        }
        if (version2.minor < this.minor) {
            return true;
        }
        if (version2.patch > this.patch) {
            return false;
        }
        return version2.patch < this.patch;
    }

    public String toString() {
        return this.getFormatted();
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public ServerVersion(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerVersion)) {
            return false;
        }
        ServerVersion other = (ServerVersion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMajor() != other.getMajor()) {
            return false;
        }
        if (this.getMinor() != other.getMinor()) {
            return false;
        }
        return this.getPatch() == other.getPatch();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMajor();
        result = result * 59 + this.getMinor();
        result = result * 59 + this.getPatch();
        return result;
    }
}

