/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit;

import com.mojang.authlib.GameProfile;
import java.io.File;
import java.util.function.Consumer;
import net.skinsrestorer.api.bukkit.events.SkinApplyBukkitEvent;
import net.skinsrestorer.api.property.IProperty;
import net.skinsrestorer.api.reflection.ReflectionUtil;
import net.skinsrestorer.api.reflection.exception.ReflectionException;
import net.skinsrestorer.api.serverinfo.ServerVersion;
import net.skinsrestorer.bukkit.SkinsRestorer;
import net.skinsrestorer.bukkit.skinrefresher.MappingSpigotSkinRefresher;
import net.skinsrestorer.bukkit.skinrefresher.PaperSkinRefresher;
import net.skinsrestorer.bukkit.skinrefresher.SpigotSkinRefresher;
import net.skinsrestorer.shadow.paperlib.PaperLib;
import net.skinsrestorer.shared.exception.InitializeException;
import net.skinsrestorer.shared.storage.Config;
import net.skinsrestorer.shared.utils.log.SRLogLevel;
import net.skinsrestorer.shared.utils.log.SRLogger;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class SkinApplierBukkit {
    private static boolean optFileChecked;
    private static boolean disableDismountPlayer;
    private static boolean disableRemountPlayer;
    private static boolean enableDismountEntities;
    private final SkinsRestorer plugin;
    private final SRLogger log;
    private final Consumer<Player> refresh;

    public SkinApplierBukkit(SkinsRestorer plugin, SRLogger log) throws InitializeException {
        this.plugin = plugin;
        this.log = log;
        this.refresh = this.detectRefresh();
    }

    private Consumer<Player> detectRefresh() throws InitializeException {
        if (this.isPaper()) {
            boolean protocolSupportExists;
            boolean viaVersionExists = this.plugin.getServer().getPluginManager().getPlugin("ViaVersion") != null;
            boolean bl = protocolSupportExists = this.plugin.getServer().getPluginManager().getPlugin("ProtocolSupport") != null;
            if (viaVersionExists || protocolSupportExists) {
                this.log.debug(SRLogLevel.WARNING, "Unsupported plugin (ViaVersion or ProtocolSupport) detected, forcing SpigotSkinRefresher");
                return this.selectSpigotRefresher();
            }
            try {
                return new PaperSkinRefresher(this.log);
            }
            catch (InitializeException e) {
                e.printStackTrace();
                this.log.severe("PaperSkinRefresher failed! (Are you using hybrid software?) Only limited support can be provided. Falling back to SpigotSkinRefresher.");
            }
        }
        return this.selectSpigotRefresher();
    }

    private Consumer<Player> selectSpigotRefresher() throws InitializeException {
        if (ReflectionUtil.SERVER_VERSION.isNewer(new ServerVersion(1, 17, 1))) {
            return new MappingSpigotSkinRefresher(this.plugin, this.log);
        }
        return new SpigotSkinRefresher(this.plugin, this.log);
    }

    protected void applySkin(Player player, IProperty property) {
        if (!player.isOnline()) {
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            SkinApplyBukkitEvent applyEvent = new SkinApplyBukkitEvent(player, property);
            Bukkit.getPluginManager().callEvent((Event)applyEvent);
            if (applyEvent.isCancelled()) {
                return;
            }
            if (property == null) {
                return;
            }
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                this.applyProperty(player, property);
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> this.updateSkin(player));
            });
        });
    }

    public void applyProperty(Player player, IProperty property) {
        try {
            GameProfile profile = this.getGameProfile(player);
            profile.getProperties().removeAll((Object)"textures");
            profile.getProperties().put((Object)"textures", (Object)property);
        }
        catch (ReflectionException e) {
            e.printStackTrace();
        }
    }

    public GameProfile getGameProfile(Player player) throws ReflectionException {
        GameProfile profile;
        Object ep = ReflectionUtil.invokeMethod(player.getClass(), player, "getHandle");
        try {
            profile = (GameProfile)ReflectionUtil.invokeMethod(ep.getClass(), ep, "getProfile");
        }
        catch (Exception e) {
            profile = (GameProfile)ReflectionUtil.getFieldByType(ep, "GameProfile");
        }
        return profile;
    }

    public void updateSkin(Player player) {
        if (!player.isOnline()) {
            return;
        }
        if (!optFileChecked) {
            this.checkOptFile();
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            Entity vehicle = player.getVehicle();
            if (Config.DISMOUNT_PLAYER_ON_UPDATE && !disableDismountPlayer && vehicle != null) {
                vehicle.removePassenger((Entity)player);
                if (Config.REMOUNT_PLAYER_ON_UPDATE && !disableRemountPlayer) {
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                        if (vehicle.isValid()) {
                            vehicle.addPassenger((Entity)player);
                        }
                    }, 1L);
                }
            }
            if ((Config.DISMOUNT_PASSENGERS_ON_UPDATE || enableDismountEntities) && !player.isEmpty()) {
                for (Entity passenger : player.getPassengers()) {
                    player.removePassenger(passenger);
                }
            }
            for (Player ps : Bukkit.getOnlinePlayers()) {
                try {
                    ps.hidePlayer((Plugin)this.plugin, player);
                }
                catch (NoSuchMethodError ignored) {
                    ps.hidePlayer(player);
                }
                try {
                    ps.showPlayer((Plugin)this.plugin, player);
                }
                catch (NoSuchMethodError ignored) {
                    ps.showPlayer(player);
                }
            }
            this.refresh.accept(player);
        });
    }

    private void checkOptFile() {
        File fileDisableDismountPlayer = new File(this.plugin.getDataFolder(), "disablesdismountplayer");
        File fileDisableRemountPlayer = new File(this.plugin.getDataFolder(), "disablesremountplayer");
        File fileEnableDismountEntities = new File(this.plugin.getDataFolder(), "enablesdismountentities");
        File fileTxtDisableDismountPlayer = new File(this.plugin.getDataFolder(), "disableDismountPlayer.txt");
        File fileTxtDisableRemountPlayer = new File(this.plugin.getDataFolder(), "disableRemountPlayer.txt");
        File fileTxtEnableDismountEntities = new File(this.plugin.getDataFolder(), "enableDismountEntities.txt");
        disableDismountPlayer = fileDisableDismountPlayer.exists() || fileTxtDisableDismountPlayer.exists();
        disableRemountPlayer = fileDisableRemountPlayer.exists() || fileTxtDisableRemountPlayer.exists();
        enableDismountEntities = fileEnableDismountEntities.exists() || fileTxtEnableDismountEntities.exists();
        this.log.debug("[Debug] Opt Files: { disableDismountPlayer: " + disableDismountPlayer + ", disableRemountPlayer: " + disableRemountPlayer + ", enableDismountEntities: " + enableDismountEntities + " }");
        optFileChecked = true;
    }

    private boolean isPaper() {
        if (PaperLib.isPaper() && ReflectionUtil.SERVER_VERSION.isNewer(new ServerVersion(1, 11, 2))) {
            if (this.hasPaperMethods()) {
                return true;
            }
            this.log.debug(SRLogLevel.WARNING, "Paper detected, but the methods are missing. Disabling Paper Refresher.");
            return false;
        }
        return false;
    }

    private boolean hasPaperMethods() {
        try {
            ReflectionUtil.getBukkitClass("entity.CraftPlayer").getDeclaredMethod("refreshPlayer", new Class[0]);
            return true;
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            return false;
        }
    }

    public SkinApplierBukkit(SkinsRestorer plugin, SRLogger log, Consumer<Player> refresh) {
        this.plugin = plugin;
        this.log = log;
        this.refresh = refresh;
    }

    public static void setOptFileChecked(boolean optFileChecked) {
        SkinApplierBukkit.optFileChecked = optFileChecked;
    }

    public Consumer<Player> getRefresh() {
        return this.refresh;
    }
}

