/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.file.Files;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import net.skinsrestorer.api.PlayerWrapper;
import net.skinsrestorer.api.SkinsRestorerAPI;
import net.skinsrestorer.api.exception.SkinRequestException;
import net.skinsrestorer.api.interfaces.ISRPlayer;
import net.skinsrestorer.api.property.GenericProperty;
import net.skinsrestorer.api.property.IProperty;
import net.skinsrestorer.api.reflection.ReflectionUtil;
import net.skinsrestorer.api.serverinfo.Platform;
import net.skinsrestorer.bukkit.SkinApplierBukkit;
import net.skinsrestorer.bukkit.SkinsGUI;
import net.skinsrestorer.bukkit.commands.GUICommand;
import net.skinsrestorer.bukkit.commands.SkinCommand;
import net.skinsrestorer.bukkit.commands.SrCommand;
import net.skinsrestorer.bukkit.listener.PlayerJoin;
import net.skinsrestorer.bukkit.listener.ProtocolLibJoinListener;
import net.skinsrestorer.bukkit.utils.BukkitConsoleImpl;
import net.skinsrestorer.bukkit.utils.UpdateDownloaderGithub;
import net.skinsrestorer.shadow.aikar.commands.PaperCommandManager;
import net.skinsrestorer.shadow.bstats.bukkit.Metrics;
import net.skinsrestorer.shadow.bstats.charts.SingleLineChart;
import net.skinsrestorer.shadow.spiget.UpdateCallback;
import net.skinsrestorer.shared.exception.InitializeException;
import net.skinsrestorer.shared.interfaces.ISRPlugin;
import net.skinsrestorer.shared.storage.Config;
import net.skinsrestorer.shared.storage.Locale;
import net.skinsrestorer.shared.storage.SkinStorage;
import net.skinsrestorer.shared.storage.YamlConfig;
import net.skinsrestorer.shared.update.UpdateChecker;
import net.skinsrestorer.shared.update.UpdateCheckerGitHub;
import net.skinsrestorer.shared.utils.MetricsCounter;
import net.skinsrestorer.shared.utils.SharedMethods;
import net.skinsrestorer.shared.utils.WrapperFactory;
import net.skinsrestorer.shared.utils.connections.MineSkinAPI;
import net.skinsrestorer.shared.utils.connections.MojangAPI;
import net.skinsrestorer.shared.utils.log.LoggerImpl;
import net.skinsrestorer.shared.utils.log.SRLogger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SkinsRestorer
extends JavaPlugin
implements ISRPlugin {
    private final MetricsCounter metricsCounter = new MetricsCounter();
    private final SRLogger srLogger = new SRLogger(this.getDataFolder(), new LoggerImpl(this.getServer().getLogger(), new BukkitConsoleImpl(this.getServer().getConsoleSender())), true);
    private final MojangAPI mojangAPI = new MojangAPI(this.srLogger, Platform.BUKKIT, this.metricsCounter);
    private final MineSkinAPI mineSkinAPI = new MineSkinAPI(this.srLogger, this.mojangAPI, this.metricsCounter);
    private final SkinStorage skinStorage = new SkinStorage(this.srLogger, this.mojangAPI, this.mineSkinAPI);
    private final SkinsRestorerAPI skinsRestorerAPI = new SkinsRestorerBukkitAPI(this.mojangAPI, this.skinStorage);
    private SkinApplierBukkit skinApplierBukkit;
    private boolean bungeeEnabled;
    private boolean updateDownloaded = false;
    private UpdateChecker updateChecker;
    private UpdateDownloaderGithub updateDownloader;
    private SkinCommand skinCommand;
    private PaperCommandManager manager;

    private static Map<String, GenericProperty> convertToObject(byte[] byteArr) {
        Map<String, GenericProperty> map = new TreeMap<String, GenericProperty>();
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(byteArr);
            ObjectInputStream ois = new ObjectInputStream(bis);
            while (bis.available() > 0) {
                map = (Map)ois.readObject();
            }
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
        return map;
    }

    @Override
    public String getVersion() {
        return this.getDescription().getVersion();
    }

    public void onEnable() {
        this.srLogger.load(this.getDataFolder());
        File updaterDisabled = new File(this.getDataFolder(), "noupdate.txt");
        Metrics metrics = new Metrics(this, 1669);
        metrics.addCustomChart(new SingleLineChart("mineskin_calls", this.metricsCounter::collectMineskinCalls));
        metrics.addCustomChart(new SingleLineChart("minetools_calls", this.metricsCounter::collectMinetoolsCalls));
        metrics.addCustomChart(new SingleLineChart("mojang_calls", this.metricsCounter::collectMojangCalls));
        metrics.addCustomChart(new SingleLineChart("ashcon_calls", this.metricsCounter::collectAshconCalls));
        try {
            this.skinApplierBukkit = new SkinApplierBukkit(this, this.srLogger);
        }
        catch (InitializeException e) {
            this.srLogger.severe(ChatColor.RED + ChatColor.UNDERLINE.toString() + "Could not initialize SkinApplier! Please report this on our discord server! ", e);
        }
        this.srLogger.info(ChatColor.GREEN + "Detected Minecraft " + ChatColor.YELLOW + ReflectionUtil.SERVER_VERSION_STRING + ChatColor.GREEN + ", using " + ChatColor.YELLOW + this.skinApplierBukkit.getRefresh().getClass().getSimpleName() + ChatColor.GREEN + ".");
        if (this.getServer().getPluginManager().getPlugin("ViaVersion") != null) {
            try {
                Class.forName("com.viaversion.viaversion.api.Via");
            }
            catch (ClassNotFoundException e) {
                this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> this.srLogger.severe("Outdated ViaVersion found! Please update to at least ViaVersion 4.0.0 for SkinsRestorer to work again!"), 50L, 1200L);
            }
        }
        if (this.getServer().getPluginManager().getPlugin("MundoSK") != null) {
            try {
                YamlConfig mundoConfig = new YamlConfig(new File(this.getDataFolder().getParentFile(), "MundoSK"), "config.yml", false, this.srLogger);
                mundoConfig.reload();
                if (mundoConfig.getBoolean("enable_custom_skin_and_tablist")) {
                    this.srLogger.warning(ChatColor.DARK_RED + "----------------------------------------------");
                    this.srLogger.warning(ChatColor.DARK_RED + "             [CRITICAL WARNING]");
                    this.srLogger.warning(ChatColor.RED + "We have detected MundoSK on your server with " + ChatColor.YELLOW + "'enable_custom_skin_and_tablist: " + ChatColor.DARK_RED + ChatColor.UNDERLINE + "true" + ChatColor.YELLOW + "' " + ChatColor.RED + ".");
                    this.srLogger.warning(ChatColor.RED + "That setting is located in \u00a7e/plugins/MundoSK/config.yml");
                    this.srLogger.warning(ChatColor.RED + "You have to disable ('false') it to get SkinsRestorer to work!");
                    this.srLogger.warning(ChatColor.DARK_RED + "----------------------------------------------");
                }
            }
            catch (Exception mundoConfig) {
                // empty catch block
            }
        }
        this.checkBungeeMode();
        if (!updaterDisabled.exists()) {
            this.updateChecker = new UpdateCheckerGitHub(2124, this.getDescription().getVersion(), this.srLogger, "SkinsRestorerUpdater/Bukkit");
            this.updateDownloader = new UpdateDownloaderGithub(this);
            this.checkUpdate(this.bungeeEnabled, true);
            int delayInt = 60 + new Random().nextInt(181);
            this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> this.checkUpdate(this.bungeeEnabled, false), 1200L * (long)delayInt, 1200L * (long)delayInt);
        } else {
            this.srLogger.info("Updater Disabled");
        }
        Bukkit.getPluginManager().registerEvents((Listener)new SkinsGUI(this, this.srLogger), (Plugin)this);
        if (this.bungeeEnabled) {
            Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)this, "sr:skinchange");
            Bukkit.getMessenger().registerIncomingPluginChannel((Plugin)this, "sr:skinchange", (channel, player, message) -> {
                if (!channel.equals("sr:skinchange")) {
                    return;
                }
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
                    block4: {
                        DataInputStream in = new DataInputStream(new ByteArrayInputStream(message));
                        try {
                            String subChannel = in.readUTF();
                            if (!subChannel.equalsIgnoreCase("SkinUpdate")) break block4;
                            try {
                                this.skinsRestorerAPI.applySkin(new PlayerWrapper(player), this.mojangAPI.createProperty(in.readUTF(), in.readUTF(), in.readUTF()));
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            this.skinApplierBukkit.updateSkin(player);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            });
            Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)this, "sr:messagechannel");
            Bukkit.getMessenger().registerIncomingPluginChannel((Plugin)this, "sr:messagechannel", (channel, channelPlayer, message) -> {
                if (!channel.equals("sr:messagechannel")) {
                    return;
                }
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
                    DataInputStream in = new DataInputStream(new ByteArrayInputStream(message));
                    try {
                        Player player;
                        String subChannel = in.readUTF();
                        if (subChannel.equalsIgnoreCase("OPENGUI")) {
                            player = Bukkit.getPlayer((String)in.readUTF());
                            if (player == null) {
                                return;
                            }
                            SkinsGUI.getMenus().put(player.getName(), 0);
                            this.requestSkinsFromBungeeCord(player, 0);
                        }
                        if (subChannel.equalsIgnoreCase("returnSkins")) {
                            player = Bukkit.getPlayer((String)in.readUTF());
                            if (player == null) {
                                return;
                            }
                            int page = in.readInt();
                            short len = in.readShort();
                            byte[] msgBytes = new byte[len];
                            in.readFully(msgBytes);
                            Map<String, GenericProperty> skinList = SkinsRestorer.convertToObject(msgBytes);
                            TreeMap<String, IProperty> newSkinList = new TreeMap<String, IProperty>();
                            skinList.forEach((name, property) -> newSkinList.put((String)name, this.mojangAPI.createProperty(property.getName(), property.getValue(), property.getSignature())));
                            SkinsGUI skinsGUI = new SkinsGUI(this, this.srLogger);
                            Inventory inventory = skinsGUI.getGUI(player, ++page, newSkinList);
                            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this, () -> player.openInventory(inventory));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            });
            return;
        }
        Config.load(this.getDataFolder(), this.getResource("config.yml"), this.srLogger);
        Locale.load(this.getDataFolder(), this.srLogger);
        if (!this.initStorage()) {
            return;
        }
        this.initCommands();
        if (!Config.ENABLE_PROTOCOL_LISTENER || Bukkit.getPluginManager().getPlugin("ProtocolLib") == null) {
            Bukkit.getPluginManager().registerEvents((Listener)new PlayerJoin(this, this.srLogger), (Plugin)this);
        } else {
            this.srLogger.info("Hooking into ProtocolLib for instant skins on join!");
            new ProtocolLibJoinListener(this);
        }
        if (!this.bungeeEnabled) {
            SharedMethods.runServiceCheck(this.mojangAPI, this.srLogger);
        }
    }

    public void requestSkinsFromBungeeCord(Player player, int page) {
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(bytes);
            out.writeUTF("getSkins");
            out.writeUTF(player.getName());
            out.writeInt(page);
            player.sendPluginMessage((Plugin)this, "sr:messagechannel", bytes.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void requestSkinClearFromBungeeCord(Player player) {
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(bytes);
            out.writeUTF("clearSkin");
            out.writeUTF(player.getName());
            player.sendPluginMessage((Plugin)this, "sr:messagechannel", bytes.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void requestSkinSetFromBungeeCord(Player player, String skin) {
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(bytes);
            out.writeUTF("setSkin");
            out.writeUTF(player.getName());
            out.writeUTF(skin);
            player.sendPluginMessage((Plugin)this, "sr:messagechannel", bytes.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initCommands() {
        this.manager = new PaperCommandManager((Plugin)this);
        this.prepareACF(this.manager, this.srLogger);
        this.skinCommand = new SkinCommand(this, this.srLogger);
        this.manager.registerCommand(this.skinCommand);
        this.manager.registerCommand(new SrCommand(this, this.srLogger));
        this.manager.registerCommand(new GUICommand(this, new SkinsGUI(this, this.srLogger)));
    }

    private boolean initStorage() {
        if (!SharedMethods.initMysql(this.srLogger, this.skinStorage, this.getDataFolder())) {
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return false;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, this.skinStorage::preloadDefaultSkins);
        return true;
    }

    private void checkBungeeMode() {
        this.bungeeEnabled = false;
        try {
            try {
                this.bungeeEnabled = this.getServer().spigot().getConfig().getBoolean("settings.bungeecord");
            }
            catch (NoSuchMethodError ignored) {
                this.srLogger.warning("It is not recommended to use non spigot implementations! Use Paper/Spigot for SkinsRestorer! ");
            }
            if (!this.bungeeEnabled && new File("spigot.yml").exists()) {
                this.bungeeEnabled = YamlConfiguration.loadConfiguration((File)new File("spigot.yml")).getBoolean("settings.bungeecord");
            }
            if (!this.bungeeEnabled && new File("paper.yml").exists()) {
                this.bungeeEnabled = YamlConfiguration.loadConfiguration((File)new File("paper.yml")).getBoolean("settings.velocity-support.enabled");
            }
            File bungeeModeEnabled = new File(this.getDataFolder(), "enableBungeeMode");
            if (!this.bungeeEnabled && bungeeModeEnabled.exists()) {
                this.bungeeEnabled = true;
                return;
            }
            File bungeeModeDisabled = new File(this.getDataFolder(), "disableBungeeMode");
            if (bungeeModeDisabled.exists()) {
                this.bungeeEnabled = false;
                return;
            }
        }
        catch (Exception bungeeModeEnabled) {
            // empty catch block
        }
        StringBuilder sb1 = new StringBuilder("Server is in bungee mode!");
        sb1.append("\nif you are NOT using bungee in your network, set spigot.yml -> bungeecord: false");
        sb1.append("\n\nInstalling Bungee:");
        sb1.append("\nDownload the latest version from https://www.spigotmc.org/resources/skinsrestorer.2124/");
        sb1.append("\nPlace the SkinsRestorer.jar in ./plugins/ folders of every spigot server.");
        sb1.append("\nPlace the plugin in ./plugins/ folder of every BungeeCord server.");
        sb1.append("\nCheck & set on every Spigot server spigot.yml -> bungeecord: true");
        sb1.append("\nRestart (/restart or /stop) all servers [Plugman or /reload are NOT supported, use /stop or /end]");
        sb1.append("\n\nBungeeCord now has SkinsRestorer installed with the integration of Spigot!");
        sb1.append("\nYou may now Configure SkinsRestorer on Bungee (BungeeCord plugins folder /plugins/SkinsRestorer)");
        File warning = new File(this.getDataFolder(), "(README) Use bungee config for settings! (README)");
        try {
            if (this.bungeeEnabled && !warning.exists()) {
                warning.getParentFile().mkdirs();
                warning.createNewFile();
                try (FileWriter writer = new FileWriter(warning);){
                    writer.write(String.valueOf(sb1));
                }
            }
            if (!this.bungeeEnabled) {
                Files.deleteIfExists(warning.toPath());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.bungeeEnabled) {
            this.srLogger.info("-------------------------/Warning\\-------------------------");
            this.srLogger.info("This plugin is running in Bungee mode!");
            this.srLogger.info("You have to do all configuration at config file");
            this.srLogger.info("inside your Bungeecord server.");
            this.srLogger.info("(Bungeecord-Server/plugins/SkinsRestorer/).");
            this.srLogger.info("-------------------------\\Warning/-------------------------");
        }
    }

    private void checkUpdate(final boolean bungeeMode, final boolean showUpToDate) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> this.updateChecker.checkForUpdate(new UpdateCallback(){

            @Override
            public void updateAvailable(String newVersion, String downloadUrl, boolean hasDirectDownload) {
                if (SkinsRestorer.this.updateDownloaded) {
                    return;
                }
                String failReason = null;
                if (hasDirectDownload) {
                    if (SkinsRestorer.this.updateDownloader.downloadUpdate()) {
                        SkinsRestorer.this.updateDownloaded = true;
                    } else {
                        failReason = SkinsRestorer.this.updateDownloader.getFailReason().toString();
                    }
                }
                SkinsRestorer.this.updateChecker.getUpdateAvailableMessages(newVersion, downloadUrl, hasDirectDownload, SkinsRestorer.this.getVersion(), bungeeMode, true, failReason).forEach(SkinsRestorer.this.srLogger::info);
            }

            @Override
            public void upToDate() {
                if (!showUpToDate) {
                    return;
                }
                SkinsRestorer.this.updateChecker.getUpToDateMessages(SkinsRestorer.this.getVersion(), bungeeMode).forEach(SkinsRestorer.this.srLogger::info);
            }
        }));
    }

    @Override
    public MetricsCounter getMetricsCounter() {
        return this.metricsCounter;
    }

    public SRLogger getSrLogger() {
        return this.srLogger;
    }

    public MojangAPI getMojangAPI() {
        return this.mojangAPI;
    }

    public MineSkinAPI getMineSkinAPI() {
        return this.mineSkinAPI;
    }

    @Override
    public SkinStorage getSkinStorage() {
        return this.skinStorage;
    }

    public SkinsRestorerAPI getSkinsRestorerAPI() {
        return this.skinsRestorerAPI;
    }

    public SkinApplierBukkit getSkinApplierBukkit() {
        return this.skinApplierBukkit;
    }

    public boolean isBungeeEnabled() {
        return this.bungeeEnabled;
    }

    public boolean isUpdateDownloaded() {
        return this.updateDownloaded;
    }

    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    public UpdateDownloaderGithub getUpdateDownloader() {
        return this.updateDownloader;
    }

    public SkinCommand getSkinCommand() {
        return this.skinCommand;
    }

    public PaperCommandManager getManager() {
        return this.manager;
    }

    private class SkinsRestorerBukkitAPI
    extends SkinsRestorerAPI {
        public SkinsRestorerBukkitAPI(MojangAPI mojangAPI, SkinStorage skinStorage) {
            super(mojangAPI, SkinsRestorer.this.mineSkinAPI, skinStorage, new WrapperFactoryBukkit());
        }

        @Override
        public void applySkin(PlayerWrapper playerWrapper) throws SkinRequestException {
            this.applySkin(playerWrapper, playerWrapper.get(Player.class).getName());
        }

        @Override
        public void applySkin(PlayerWrapper playerWrapper, String name) throws SkinRequestException {
            this.applySkin(playerWrapper, SkinsRestorer.this.skinStorage.getSkinForPlayer(name));
        }

        @Override
        public void applySkin(PlayerWrapper playerWrapper, IProperty props) {
            SkinsRestorer.this.skinApplierBukkit.applySkin(playerWrapper.get(Player.class), props);
        }
    }

    private static class WrapperFactoryBukkit
    extends WrapperFactory {
        private WrapperFactoryBukkit() {
        }

        @Override
        public ISRPlayer wrap(final Object playerInstance) {
            if (playerInstance instanceof Player) {
                final Player player = (Player)playerInstance;
                return new ISRPlayer(){

                    @Override
                    public PlayerWrapper getWrapper() {
                        return new PlayerWrapper(playerInstance);
                    }

                    @Override
                    public String getName() {
                        return player.getName();
                    }

                    @Override
                    public void sendMessage(String message) {
                        player.sendMessage(message);
                    }
                };
            }
            throw new IllegalArgumentException("Player instance is not valid!");
        }
    }
}

