/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit.commands;

import net.skinsrestorer.bukkit.SkinsGUI;
import net.skinsrestorer.bukkit.SkinsRestorer;
import net.skinsrestorer.shadow.aikar.commands.BaseCommand;
import net.skinsrestorer.shadow.aikar.commands.CommandHelp;
import net.skinsrestorer.shadow.aikar.commands.annotation.CommandAlias;
import net.skinsrestorer.shadow.aikar.commands.annotation.CommandPermission;
import net.skinsrestorer.shadow.aikar.commands.annotation.Default;
import net.skinsrestorer.shadow.aikar.commands.annotation.HelpCommand;
import net.skinsrestorer.shared.storage.CooldownStorage;
import net.skinsrestorer.shared.storage.Locale;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;

@CommandAlias(value="skins")
@CommandPermission(value="%skins")
public class GUICommand
extends BaseCommand {
    private final SkinsRestorer plugin;
    private final SkinsGUI skinsGUI;

    @HelpCommand
    public static void onHelp(CommandSender sender, CommandHelp help) {
        sender.sendMessage("SkinsRestorer Help");
        help.showHelp();
    }

    @Default
    @CommandPermission(value="%skins")
    public void onDefault(Player player) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            if (!player.hasPermission("skinsrestorer.bypasscooldown") && CooldownStorage.hasCooldown(player.getName())) {
                player.sendMessage(Locale.SKIN_COOLDOWN.replace("%s", "" + CooldownStorage.getCooldown(player.getName())));
                return;
            }
            player.sendMessage(Locale.SKINSMENU_OPEN);
            SkinsGUI.getMenus().put(player.getName(), 0);
            Inventory inventory = this.skinsGUI.getGUI(player, 0);
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> player.openInventory(inventory));
        });
    }

    public GUICommand(SkinsRestorer plugin, SkinsGUI skinsGUI) {
        this.plugin = plugin;
        this.skinsGUI = skinsGUI;
    }
}

