/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit.commands;

import java.util.concurrent.TimeUnit;
import net.skinsrestorer.api.PlayerWrapper;
import net.skinsrestorer.api.exception.SkinRequestException;
import net.skinsrestorer.api.interfaces.ISRCommandSender;
import net.skinsrestorer.api.property.IProperty;
import net.skinsrestorer.bukkit.SkinsRestorer;
import net.skinsrestorer.shadow.aikar.commands.BaseCommand;
import net.skinsrestorer.shadow.aikar.commands.CommandHelp;
import net.skinsrestorer.shadow.aikar.commands.InvalidCommandArgument;
import net.skinsrestorer.shadow.aikar.commands.annotation.CommandAlias;
import net.skinsrestorer.shadow.aikar.commands.annotation.CommandCompletion;
import net.skinsrestorer.shadow.aikar.commands.annotation.CommandPermission;
import net.skinsrestorer.shadow.aikar.commands.annotation.Default;
import net.skinsrestorer.shadow.aikar.commands.annotation.Description;
import net.skinsrestorer.shadow.aikar.commands.annotation.HelpCommand;
import net.skinsrestorer.shadow.aikar.commands.annotation.Optional;
import net.skinsrestorer.shadow.aikar.commands.annotation.Single;
import net.skinsrestorer.shadow.aikar.commands.annotation.Subcommand;
import net.skinsrestorer.shadow.aikar.commands.annotation.Syntax;
import net.skinsrestorer.shadow.aikar.commands.bukkit.contexts.OnlinePlayer;
import net.skinsrestorer.shared.storage.Config;
import net.skinsrestorer.shared.storage.CooldownStorage;
import net.skinsrestorer.shared.storage.Locale;
import net.skinsrestorer.shared.utils.C;
import net.skinsrestorer.shared.utils.log.SRLogger;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

@CommandAlias(value="skin")
@CommandPermission(value="%skin")
public class SkinCommand
extends BaseCommand {
    private final SkinsRestorer plugin;
    private final SRLogger log;

    @Default
    public void onDefault(CommandSender sender) {
        this.onHelp(sender, this.getCurrentCommandManager().generateCommandHelp());
    }

    @Default
    @CommandPermission(value="%skinSet")
    @Description(value="%helpSkinSet")
    @Syntax(value="%SyntaxDefaultCommand")
    public void onSkinSetShort(Player player, @Single String skin) {
        this.onSkinSetOther((CommandSender)player, new OnlinePlayer(player), skin, null);
    }

    @HelpCommand
    @Syntax(value=" [help]")
    public void onHelp(CommandSender sender, CommandHelp help) {
        if (Config.ENABLE_CUSTOM_HELP) {
            this.sendHelp(sender);
        } else {
            help.showHelp();
        }
    }

    @Subcommand(value="clear")
    @CommandPermission(value="%skinClear")
    @Description(value="%helpSkinClear")
    public void onSkinClear(Player player) {
        this.onSkinClearOther((CommandSender)player, new OnlinePlayer(player));
    }

    @Subcommand(value="clear")
    @CommandPermission(value="%skinClearOther")
    @CommandCompletion(value="@players")
    @Syntax(value="%SyntaxSkinClearOther")
    @Description(value="%helpSkinClearOther")
    public void onSkinClearOther(CommandSender sender, @Single OnlinePlayer target) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            if (!sender.hasPermission("skinsrestorer.bypasscooldown") && CooldownStorage.hasCooldown(sender.getName())) {
                sender.sendMessage(Locale.SKIN_COOLDOWN.replace("%s", "" + CooldownStorage.getCooldown(sender.getName())));
                return;
            }
            Player player = target.getPlayer();
            String pName = player.getName();
            String skin = this.plugin.getSkinStorage().getDefaultSkinName(pName, true);
            this.plugin.getSkinStorage().removeSkin(pName);
            if (this.setSkin(this.wrap(sender), new PlayerWrapper(player), skin, false, true, null)) {
                if (sender == player) {
                    sender.sendMessage(Locale.SKIN_CLEAR_SUCCESS);
                } else {
                    sender.sendMessage(Locale.SKIN_CLEAR_ISSUER.replace("%player", pName));
                }
            }
        });
    }

    @Subcommand(value="update")
    @CommandPermission(value="%skinUpdate")
    @Description(value="%helpSkinUpdate")
    public void onSkinUpdate(Player player) {
        this.onSkinUpdateOther((CommandSender)player, new OnlinePlayer(player));
    }

    @Subcommand(value="update")
    @CommandPermission(value="%skinUpdateOther")
    @CommandCompletion(value="@players")
    @Description(value="%helpSkinUpdateOther")
    @Syntax(value="%SyntaxSkinUpdateOther")
    public void onSkinUpdateOther(CommandSender sender, @Single OnlinePlayer target) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            if (!sender.hasPermission("skinsrestorer.bypasscooldown") && CooldownStorage.hasCooldown(sender.getName())) {
                sender.sendMessage(Locale.SKIN_COOLDOWN.replace("%s", "" + CooldownStorage.getCooldown(sender.getName())));
                return;
            }
            Player player = target.getPlayer();
            java.util.Optional<String> skin = this.plugin.getSkinStorage().getSkinName(player.getName());
            try {
                if (skin.isPresent()) {
                    if (skin.get().startsWith(" ")) {
                        sender.sendMessage(Locale.ERROR_UPDATING_URL);
                        return;
                    }
                    if (!this.plugin.getSkinStorage().updateSkinData(skin.get())) {
                        sender.sendMessage(Locale.ERROR_UPDATING_SKIN);
                        return;
                    }
                } else {
                    skin = java.util.Optional.of(this.plugin.getSkinStorage().getDefaultSkinName(player.getName(), true));
                }
            }
            catch (SkinRequestException e) {
                sender.sendMessage(e.getMessage());
                return;
            }
            if (this.setSkin(this.wrap(sender), new PlayerWrapper(player), skin.get(), false, false, null)) {
                if (sender == player) {
                    sender.sendMessage(Locale.SUCCESS_UPDATING_SKIN);
                } else {
                    sender.sendMessage(Locale.SUCCESS_UPDATING_SKIN_OTHER.replace("%player", player.getName()));
                }
            }
        });
    }

    @Subcommand(value="set")
    @CommandPermission(value="%skinSet")
    @CommandCompletion(value="@skin")
    @Description(value="%helpSkinSet")
    @Syntax(value="%SyntaxSkinSet")
    public void onSkinSet(Player player, String[] skin) {
        if (skin.length == 0) {
            throw new InvalidCommandArgument(true);
        }
        this.onSkinSetOther((CommandSender)player, new OnlinePlayer(player), skin[0], null);
    }

    @Subcommand(value="set")
    @CommandPermission(value="%skinSetOther")
    @CommandCompletion(value="@players @skin")
    @Description(value="%helpSkinSetOther")
    @Syntax(value="%SyntaxSkinSetOther")
    public void onSkinSetOther(CommandSender sender, OnlinePlayer target, String skin, @Optional SkinType skinType) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            Player player = target.getPlayer();
            if (!(!Config.PER_SKIN_PERMISSIONS || sender.hasPermission("skinsrestorer.skin." + skin) || (sender.hasPermission("skinsrestorer.ownskin") || sender.getName().equalsIgnoreCase(player.getName())) && skin.equalsIgnoreCase(sender.getName()))) {
                sender.sendMessage(Locale.PLAYER_HAS_NO_PERMISSION_SKIN);
                return;
            }
            if (this.setSkin(this.wrap(sender), new PlayerWrapper(player), skin, true, false, skinType) && sender != player) {
                sender.sendMessage(Locale.ADMIN_SET_SKIN.replace("%player", player.getName()));
            }
        });
    }

    @Subcommand(value="url")
    @CommandPermission(value="%skinSetUrl")
    @CommandCompletion(value="@skinUrl")
    @Description(value="%helpSkinSetUrl")
    @Syntax(value="%SyntaxSkinUrl")
    public void onSkinSetUrl(Player player, String url, @Optional SkinType skinType) {
        if (!C.validUrl(url)) {
            player.sendMessage(Locale.ERROR_INVALID_URLSKIN);
            return;
        }
        this.onSkinSetOther((CommandSender)player, new OnlinePlayer(player), url, skinType);
    }

    private boolean setSkin(CommandSender sender, Player player, String skin) {
        return this.setSkin(this.wrap(sender), new PlayerWrapper(player), skin, true, false, null);
    }

    private boolean setSkin(ISRCommandSender sender, PlayerWrapper player, String skin, boolean save, boolean clear, SkinType skinType) {
        if (skin.equalsIgnoreCase("null")) {
            sender.sendMessage(Locale.INVALID_PLAYER.replace("%player", skin));
            return false;
        }
        if (Config.DISABLED_SKINS_ENABLED && !clear && !sender.hasPermission("skinsrestorer.bypassdisabled")) {
            for (String dskin : Config.DISABLED_SKINS) {
                if (!skin.equalsIgnoreCase(dskin)) continue;
                sender.sendMessage(Locale.SKIN_DISABLED);
                return false;
            }
        }
        String senderName = sender.getName();
        if (!sender.hasPermission("skinsrestorer.bypasscooldown") && CooldownStorage.hasCooldown(senderName)) {
            sender.sendMessage(Locale.SKIN_COOLDOWN.replace("%s", "" + CooldownStorage.getCooldown(senderName)));
            return false;
        }
        CooldownStorage.setCooldown(senderName, Config.SKIN_CHANGE_COOLDOWN, TimeUnit.SECONDS);
        String pName = player.getName();
        java.util.Optional<String> oldSkinName = this.plugin.getSkinStorage().getSkinName(pName);
        if (C.validUrl(skin)) {
            if (!(sender.hasPermission("skinsrestorer.command.set.url") || Config.SKIN_WITHOUT_PERM || clear)) {
                sender.sendMessage(Locale.PLAYER_HAS_NO_PERMISSION_URL);
                CooldownStorage.resetCooldown(senderName);
                return false;
            }
            if (!C.allowedSkinUrl(skin)) {
                sender.sendMessage(Locale.SKINURL_DISALLOWED);
                CooldownStorage.resetCooldown(senderName);
                return false;
            }
            try {
                sender.sendMessage(Locale.MS_UPDATING_SKIN);
                String skinentry = " " + pName;
                if (skinentry.length() > 16) {
                    skinentry = skinentry.substring(0, 16);
                }
                IProperty generatedSkin = this.plugin.getMineSkinAPI().genSkin(skin, String.valueOf((Object)skinType), null);
                this.plugin.getSkinStorage().setSkinData(skinentry, generatedSkin, Long.toString(System.currentTimeMillis() + 3153600000000L));
                this.plugin.getSkinStorage().setSkinName(pName, skinentry);
                this.plugin.getSkinsRestorerAPI().applySkin(player, generatedSkin);
                if (!Locale.SKIN_CHANGE_SUCCESS.isEmpty() && !Locale.SKIN_CHANGE_SUCCESS.equals(Locale.PREFIX)) {
                    player.sendMessage(Locale.SKIN_CHANGE_SUCCESS.replace("%skin", "skinUrl"));
                }
                return true;
            }
            catch (SkinRequestException e) {
                sender.sendMessage(e.getMessage());
            }
            catch (Exception e) {
                this.log.debug("[ERROR] Exception: could not generate skin url:" + skin + "\nReason= " + e.getMessage());
                sender.sendMessage(Locale.ERROR_INVALID_URLSKIN);
            }
        } else {
            try {
                if (save) {
                    this.plugin.getSkinStorage().setSkinName(pName, skin);
                }
                this.plugin.getSkinsRestorerAPI().applySkin(player, skin);
                if (!Locale.SKIN_CHANGE_SUCCESS.isEmpty() && !Locale.SKIN_CHANGE_SUCCESS.equals(Locale.PREFIX)) {
                    player.sendMessage(Locale.SKIN_CHANGE_SUCCESS.replace("%skin", skin));
                }
                return true;
            }
            catch (SkinRequestException e) {
                if (clear) {
                    this.plugin.getSkinsRestorerAPI().applySkin(player, this.plugin.getMojangAPI().createProperty("textures", "", ""));
                    this.plugin.getSkinApplierBukkit().updateSkin(player.get(Player.class));
                    return true;
                }
                sender.sendMessage(e.getMessage());
            }
        }
        CooldownStorage.setCooldown(senderName, Config.SKIN_ERROR_COOLDOWN, TimeUnit.SECONDS);
        this.rollback(pName, oldSkinName.orElse(pName), save);
        return false;
    }

    private void rollback(String pName, String oldSkinName, boolean save) {
        if (save) {
            this.plugin.getSkinStorage().setSkinName(pName, oldSkinName);
        }
    }

    private void sendHelp(CommandSender sender) {
        if (!Locale.SR_LINE.isEmpty()) {
            sender.sendMessage(Locale.SR_LINE);
        }
        sender.sendMessage(Locale.CUSTOM_HELP_IF_ENABLED.replace("%ver%", this.plugin.getVersion()));
        if (!Locale.SR_LINE.isEmpty()) {
            sender.sendMessage(Locale.SR_LINE);
        }
    }

    private ISRCommandSender wrap(final CommandSender sender) {
        return new ISRCommandSender(){

            @Override
            public void sendMessage(String message) {
                sender.sendMessage(message);
            }

            @Override
            public String getName() {
                return sender.getName();
            }

            @Override
            public boolean hasPermission(String permission) {
                return sender.hasPermission(permission);
            }
        };
    }

    public SkinCommand(SkinsRestorer plugin, SRLogger log) {
        this.plugin = plugin;
        this.log = log;
    }

    public static enum SkinType {
        STEVE,
        SLIM;

    }
}

