/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit.commands;

import com.mojang.authlib.properties.PropertyMap;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import net.skinsrestorer.api.PlayerWrapper;
import net.skinsrestorer.api.exception.SkinRequestException;
import net.skinsrestorer.api.property.IProperty;
import net.skinsrestorer.api.reflection.ReflectionUtil;
import net.skinsrestorer.bukkit.SkinApplierBukkit;
import net.skinsrestorer.bukkit.SkinsRestorer;
import net.skinsrestorer.shadow.aikar.commands.BaseCommand;
import net.skinsrestorer.shadow.aikar.commands.CommandHelp;
import net.skinsrestorer.shadow.aikar.commands.annotation.CommandAlias;
import net.skinsrestorer.shadow.aikar.commands.annotation.CommandCompletion;
import net.skinsrestorer.shadow.aikar.commands.annotation.CommandPermission;
import net.skinsrestorer.shadow.aikar.commands.annotation.Description;
import net.skinsrestorer.shadow.aikar.commands.annotation.HelpCommand;
import net.skinsrestorer.shadow.aikar.commands.annotation.Optional;
import net.skinsrestorer.shadow.aikar.commands.annotation.Single;
import net.skinsrestorer.shadow.aikar.commands.annotation.Subcommand;
import net.skinsrestorer.shadow.aikar.commands.annotation.Syntax;
import net.skinsrestorer.shadow.aikar.commands.bukkit.contexts.OnlinePlayer;
import net.skinsrestorer.shadow.gson.JsonObject;
import net.skinsrestorer.shadow.gson.JsonParser;
import net.skinsrestorer.shared.storage.Config;
import net.skinsrestorer.shared.storage.Locale;
import net.skinsrestorer.shared.utils.C;
import net.skinsrestorer.shared.utils.connections.ServiceChecker;
import net.skinsrestorer.shared.utils.log.SRLogger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

@CommandAlias(value="sr|skinsrestorer")
@CommandPermission(value="%sr")
public class SrCommand
extends BaseCommand {
    private final SkinsRestorer plugin;
    private final SRLogger logger;
    private SkinApplierBukkit skinApplierBukkit;

    @HelpCommand
    @Syntax(value=" [help]")
    public void onHelp(CommandSender sender, CommandHelp help) {
        help.showHelp();
    }

    @Subcommand(value="reload")
    @CommandPermission(value="%srReload")
    @Description(value="%helpSrReload")
    public void onReload(CommandSender sender) {
        SkinApplierBukkit.setOptFileChecked(false);
        Locale.load(this.plugin.getDataFolder(), this.logger);
        Config.load(this.plugin.getDataFolder(), this.plugin.getResource("config.yml"), this.logger);
        this.plugin.prepareACF(this.plugin.getManager(), this.plugin.getSrLogger());
        sender.sendMessage(Locale.RELOAD);
    }

    @Subcommand(value="status")
    @CommandPermission(value="%srStatus")
    @Description(value="%helpSrStatus")
    public void onStatus(CommandSender sender) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            sender.sendMessage("\u00a73----------------------------------------------");
            sender.sendMessage("\u00a77Checking needed services for SR to work properly...");
            ServiceChecker checker = new ServiceChecker();
            checker.setMojangAPI(this.plugin.getMojangAPI());
            checker.checkServices();
            ServiceChecker.ServiceCheckResponse response = checker.getResponse();
            List<String> results = response.getResults();
            if (Config.DEBUG || response.getWorkingUUID().get() < 1 || response.getWorkingProfile().get() < 1) {
                for (String result : results) {
                    if (!Config.DEBUG && !result.contains("\u2718")) continue;
                    sender.sendMessage(result);
                }
            }
            sender.sendMessage("\u00a77Working UUID API count: \u00a76" + response.getWorkingUUID());
            sender.sendMessage("\u00a77Working Profile API count: \u00a76" + response.getWorkingProfile());
            if (response.getWorkingUUID().get() >= 1 && response.getWorkingProfile().get() >= 1) {
                sender.sendMessage("\u00a7aThe plugin currently is in a working state.");
            } else {
                sender.sendMessage("\u00a7cPlugin currently can't fetch new skins. \n Connection is likely blocked because of firewall. \n Please See http://skinsrestorer.net/firewall for more info");
            }
            sender.sendMessage("\u00a73----------------------------------------------");
            sender.sendMessage("\u00a77SkinsRestorer \u00a76v" + this.plugin.getVersion());
            sender.sendMessage("\u00a77Server: \u00a76" + this.plugin.getServer().getVersion());
            sender.sendMessage("\u00a77BungeeMode: \u00a76" + this.plugin.isBungeeEnabled());
            sender.sendMessage("\u00a77Finished checking services.");
            sender.sendMessage("\u00a73----------------------------------------------");
        });
    }

    @Subcommand(value="drop|remove")
    @CommandPermission(value="%srDrop")
    @CommandCompletion(value="PLAYER|SKIN @players @players @players")
    @Description(value="%helpSrDrop")
    @Syntax(value=" <player|skin> <target> [target2]")
    public void onDrop(CommandSender sender, PlayerOrSkin playerOrSkin, String[] targets) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            if (playerOrSkin == PlayerOrSkin.PLAYER) {
                for (String targetPlayer : targets) {
                    this.plugin.getSkinStorage().removeSkin(targetPlayer);
                }
            } else {
                for (String targetSkin : targets) {
                    this.plugin.getSkinStorage().removeSkinData(targetSkin);
                }
            }
            String targetList = Arrays.toString(targets).substring(1, Arrays.toString(targets).length() - 1);
            sender.sendMessage(Locale.DATA_DROPPED.replace("%playerOrSkin", playerOrSkin.toString()).replace("%targets", targetList));
        });
    }

    @Subcommand(value="props")
    @CommandPermission(value="%srProps")
    @CommandCompletion(value="@players")
    @Description(value="%helpSrProps")
    @Syntax(value=" <target>")
    public void onProps(CommandSender sender, @Single OnlinePlayer target) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                PropertyMap propertyMap = this.plugin.getSkinApplierBukkit().getGameProfile(target.player).getProperties();
                Collection props = (Collection)ReflectionUtil.invokeMethod(propertyMap.getClass(), (Object)propertyMap, "get", new Class[]{Object.class}, new Object[]{"textures"});
                if (props == null || props.isEmpty()) {
                    sender.sendMessage(Locale.NO_SKIN_DATA);
                    return;
                }
                for (Object prop : props) {
                    String name = (String)ReflectionUtil.invokeMethod(prop, "getName");
                    String value = (String)ReflectionUtil.invokeMethod(prop, "getValue");
                    String signature = (String)ReflectionUtil.invokeMethod(prop, "getSignature");
                    byte[] decoded = Base64.getDecoder().decode(value);
                    String decodedString = new String(decoded);
                    JsonObject jsonObject = JsonParser.parseString(decodedString).getAsJsonObject();
                    String decodedSkin = jsonObject.getAsJsonObject().get("textures").getAsJsonObject().get("SKIN").getAsJsonObject().get("url").toString();
                    long timestamp = Long.parseLong(jsonObject.getAsJsonObject().get("timestamp").toString());
                    String requestDate = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss").format(new Date(timestamp));
                    sender.sendMessage("\u00a7aRequest time: \u00a7e" + requestDate);
                    sender.sendMessage("\u00a7aProfileId: \u00a7e" + jsonObject.getAsJsonObject().get("profileId").toString());
                    sender.sendMessage("\u00a7aName: \u00a7e" + jsonObject.getAsJsonObject().get("profileName").toString());
                    sender.sendMessage("\u00a7aSkinTexture: \u00a7e" + decodedSkin.substring(1, decodedSkin.length() - 1));
                    sender.sendMessage("\u00a7cMore info in console!");
                    this.logger.info("\u00a7aName: \u00a78" + name);
                    this.logger.info("\u00a7aValue : \u00a78" + value);
                    this.logger.info("\u00a7aSignature : \u00a78" + signature);
                    this.logger.info("\u00a7aValue Decoded: \u00a7e" + Arrays.toString(decoded));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                sender.sendMessage(Locale.NO_SKIN_DATA);
            }
        });
    }

    @Subcommand(value="applyskin")
    @CommandPermission(value="%srApplySkin")
    @CommandCompletion(value="@players")
    @Description(value="%helpSrApplySkin")
    @Syntax(value=" <target>")
    public void onApplySkin(CommandSender sender, @Single OnlinePlayer target) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                Player player = target.getPlayer();
                String name = player.getName();
                String skin = this.plugin.getSkinStorage().getDefaultSkinName(name);
                if (C.validUrl(skin)) {
                    this.plugin.getSkinsRestorerAPI().applySkin(new PlayerWrapper(player), this.plugin.getMineSkinAPI().genSkin(skin, null, null));
                } else {
                    this.plugin.getSkinsRestorerAPI().applySkin(new PlayerWrapper(player), skin);
                }
                sender.sendMessage("success: player skin has been refreshed!");
            }
            catch (Exception ignored) {
                sender.sendMessage("ERROR: player skin could NOT be refreshed!");
            }
        });
    }

    @Subcommand(value="createcustom")
    @CommandPermission(value="%srCreateCustom")
    @CommandCompletion(value="@skinName @skinUrl")
    @Description(value="%helpSrCreateCustom")
    @Syntax(value=" <skinName> <skinUrl> [steve/slim]")
    public void onCreateCustom(CommandSender sender, String name, String skinUrl, @Optional SkinType skinType) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                if (C.validUrl(skinUrl)) {
                    this.plugin.getSkinStorage().setSkinData(name, this.plugin.getMineSkinAPI().genSkin(skinUrl, String.valueOf((Object)skinType), null), Long.toString(System.currentTimeMillis() + 3153600000000L));
                    sender.sendMessage(Locale.SUCCESS_CREATE_SKIN.replace("%skin", name));
                } else {
                    sender.sendMessage(Locale.ERROR_INVALID_URLSKIN);
                }
            }
            catch (SkinRequestException e) {
                sender.sendMessage(e.getMessage());
            }
        });
    }

    @Subcommand(value="setskinall")
    @CommandCompletion(value="@Skin")
    @Description(value="Set the skin to evey player")
    @Syntax(value=" <Skin / Url> [steve/slim]")
    public void onSetSkinAll(CommandSender sender, String skin, @Optional SkinType skinType) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            if (!(sender instanceof ConsoleCommandSender)) {
                sender.sendMessage(Locale.PREFIX + ChatColor.DARK_RED + "Only console may execute this command!");
                return;
            }
            String skinName = " \u00b7setSkinAll";
            try {
                IProperty skinProps = null;
                skinProps = C.validUrl(skin) ? this.plugin.getMineSkinAPI().genSkin(skin, String.valueOf((Object)skinType), null) : (IProperty)this.plugin.getMojangAPI().getSkin(skin).orElse(null);
                if (skinProps == null) {
                    sender.sendMessage(Locale.PREFIX + ChatColor.DARK_RED + "no skin found....");
                    return;
                }
                this.plugin.getSkinStorage().setSkinData(skinName, skinProps);
                for (Player player : Bukkit.getOnlinePlayers()) {
                    String pName = player.getName();
                    this.plugin.getSkinStorage().setSkinName(pName, skinName);
                    this.plugin.getSkinsRestorerAPI().applySkin(new PlayerWrapper(player), skinProps);
                }
            }
            catch (SkinRequestException e) {
                sender.sendMessage(e.getMessage());
            }
        });
    }

    public SrCommand(SkinsRestorer plugin, SRLogger logger) {
        this.plugin = plugin;
        this.logger = logger;
    }

    public static enum PlayerOrSkin {
        PLAYER,
        SKIN;

    }

    public static enum SkinType {
        STEVE,
        SLIM;

    }
}

