/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit.listener;

import net.skinsrestorer.api.PlayerWrapper;
import net.skinsrestorer.api.exception.SkinRequestException;
import net.skinsrestorer.bukkit.SkinsRestorer;
import net.skinsrestorer.shared.storage.Config;
import net.skinsrestorer.shared.utils.log.SRLogger;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class PlayerJoin
implements Listener {
    private final SkinsRestorer plugin;
    private final SRLogger log;

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        if (Config.DISABLE_ON_JOIN_SKINS) {
            return;
        }
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                Player player = event.getPlayer();
                this.plugin.getSkinsRestorerAPI().applySkin(new PlayerWrapper(player), this.plugin.getSkinStorage().getDefaultSkinForPlayer(player.getName()));
            }
            catch (SkinRequestException skinRequestException) {
                // empty catch block
            }
        });
    }

    public PlayerJoin(SkinsRestorer plugin, SRLogger log) {
        this.plugin = plugin;
        this.log = log;
    }
}

