/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit.listener;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.ListenerOptions;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.comphenix.protocol.wrappers.WrappedSignedProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.skinsrestorer.api.exception.SkinRequestException;
import net.skinsrestorer.api.property.IProperty;
import net.skinsrestorer.bukkit.SkinsRestorer;
import net.skinsrestorer.bukkit.listener.protocol.WrapperPlayServerPlayerInfo;
import net.skinsrestorer.shared.storage.Config;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class ProtocolLibJoinListener {
    public ProtocolLibJoinListener(final SkinsRestorer skinsRestorer) {
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)new PacketAdapter((Plugin)skinsRestorer, ListenerPriority.LOWEST, (Iterable)ImmutableList.of((Object)PacketType.Play.Server.PLAYER_INFO), new ListenerOptions[]{ListenerOptions.ASYNC}){

            public void onPacketSending(PacketEvent event) {
                if (Config.DISABLE_ON_JOIN_SKINS) {
                    return;
                }
                WrapperPlayServerPlayerInfo wrapper = new WrapperPlayServerPlayerInfo(event.getPacket());
                if (wrapper.getAction() != EnumWrappers.PlayerInfoAction.ADD_PLAYER) {
                    return;
                }
                List<PlayerInfoData> list = wrapper.getData();
                if (list.size() < 1) {
                    return;
                }
                PlayerInfoData data = list.get(0);
                String targetName = data.getProfile().getName();
                Player targetPlayer = this.plugin.getServer().getPlayer(targetName);
                if (targetPlayer == null) {
                    return;
                }
                if (targetPlayer.hasMetadata("skinsrestorer.appliedOnJoin")) {
                    return;
                }
                try {
                    IProperty property = skinsRestorer.getSkinStorage().getDefaultSkinForPlayer(targetName);
                    skinsRestorer.getSkinApplierBukkit().applyProperty(targetPlayer, property);
                    targetPlayer.setMetadata("skinsrestorer.appliedOnJoin", (MetadataValue)new FixedMetadataValue((Plugin)skinsRestorer, (Object)true));
                    data.getProfile().getProperties().removeAll((Object)"textures");
                    data.getProfile().getProperties().put((Object)"textures", (Object)new WrappedSignedProperty(property.getName(), property.getValue(), property.getSignature()));
                    wrapper.setData(list);
                }
                catch (SkinRequestException skinRequestException) {
                    // empty catch block
                }
            }
        });
    }
}

