/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit.skinrefresher;

import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.Consumer;
import net.skinsrestorer.api.reflection.ReflectionUtil;
import net.skinsrestorer.bukkit.utils.MappingManager;
import net.skinsrestorer.mappings.shared.IMapping;
import net.skinsrestorer.shared.exception.InitializeException;
import net.skinsrestorer.shared.utils.log.SRLogger;
import org.bukkit.entity.Player;

public final class PaperSkinRefresher
implements Consumer<Player> {
    private final Method refreshPlayerMethod;
    private final Consumer<Player> triggerHealthUpdate;

    public PaperSkinRefresher(SRLogger logger) throws InitializeException {
        try {
            Consumer<Player> triggerHealthUpdate;
            this.refreshPlayerMethod = ReflectionUtil.getBukkitClass("entity.CraftPlayer").getDeclaredMethod("refreshPlayer", new Class[0]);
            this.refreshPlayerMethod.setAccessible(true);
            try {
                Method healthUpdateMethod = ReflectionUtil.getBukkitClass("entity.CraftPlayer").getDeclaredMethod("triggerHealthUpdate", new Class[0]);
                healthUpdateMethod.setAccessible(true);
                triggerHealthUpdate = player -> {
                    try {
                        healthUpdateMethod.invoke(player, new Object[0]);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                };
            }
            catch (NoSuchMethodException ignored) {
                try {
                    Method getHandleMethod = ReflectionUtil.getBukkitClass("entity.CraftPlayer").getDeclaredMethod("getHandle", new Class[0]);
                    getHandleMethod.setAccessible(true);
                    Method healthUpdateMethod = getHandleMethod.getReturnType().getDeclaredMethod("triggerHealthUpdate", new Class[0]);
                    healthUpdateMethod.setAccessible(true);
                    triggerHealthUpdate = player -> {
                        try {
                            healthUpdateMethod.invoke(getHandleMethod.invoke(player, new Object[0]), new Object[0]);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    };
                }
                catch (NoSuchMethodException ignored2) {
                    Optional<IMapping> mapping = MappingManager.getMapping();
                    if (!mapping.isPresent()) {
                        logger.severe("Your Minecraft version is not supported by this version of SkinsRestorer! Is there a newer version available? If not, join our discord server!");
                        throw new InitializeException("No mapping for this minecraft version found!");
                    }
                    triggerHealthUpdate = player -> {
                        try {
                            ((IMapping)mapping.get()).triggerHealthUpdate((Player)player);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    };
                }
            }
            this.triggerHealthUpdate = triggerHealthUpdate;
            logger.info("Using PaperSkinRefresher");
        }
        catch (Exception e) {
            logger.info("Failed PaperSkinRefresher");
            throw new InitializeException(e);
        }
    }

    @Override
    public void accept(Player player) {
        this.refreshPlayerMethod.invoke((Object)player, new Object[0]);
        this.triggerHealthUpdate.accept(player);
    }
}

