/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit.skinrefresher;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Hashing;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import net.skinsrestorer.api.reflection.ReflectionUtil;
import net.skinsrestorer.api.reflection.exception.ReflectionException;
import net.skinsrestorer.bukkit.SkinsRestorer;
import net.skinsrestorer.bukkit.skinrefresher.ViaWorkaround;
import net.skinsrestorer.mappings.shared.ViaPacketData;
import net.skinsrestorer.shared.exception.InitializeException;
import net.skinsrestorer.shared.utils.log.SRLogger;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public final class SpigotSkinRefresher
implements Consumer<Player> {
    private final SkinsRestorer plugin;
    private final Class<?> playOutRespawn;
    private final Class<?> playOutPlayerInfo;
    private final Class<?> playOutPosition;
    private final Class<?> packet;
    private final Class<?> playOutHeldItemSlot;
    private final Method getHandleMethod;
    private Enum<?> removePlayerEnum;
    private Enum<?> addPlayerEnum;
    private boolean useViabackwards = false;

    public SpigotSkinRefresher(SkinsRestorer plugin, SRLogger log) throws InitializeException {
        this.plugin = plugin;
        try {
            this.packet = ReflectionUtil.getNMSClass("Packet", "net.minecraft.network.protocol.Packet");
            this.playOutHeldItemSlot = ReflectionUtil.getNMSClass("PacketPlayOutHeldItemSlot", "net.minecraft.network.protocol.game.PacketPlayOutHeldItemSlot");
            this.playOutPosition = ReflectionUtil.getNMSClass("PacketPlayOutPosition", "net.minecraft.network.protocol.game.PacketPlayOutPosition");
            this.playOutPlayerInfo = ReflectionUtil.getNMSClass("PacketPlayOutPlayerInfo", "net.minecraft.network.protocol.game.PacketPlayOutPlayerInfo");
            this.playOutRespawn = ReflectionUtil.getNMSClass("PacketPlayOutRespawn", "net.minecraft.network.protocol.game.PacketPlayOutRespawn");
            try {
                this.removePlayerEnum = ReflectionUtil.getEnum(this.playOutPlayerInfo, "EnumPlayerInfoAction", "REMOVE_PLAYER");
                this.addPlayerEnum = ReflectionUtil.getEnum(this.playOutPlayerInfo, "EnumPlayerInfoAction", "ADD_PLAYER");
            }
            catch (Exception e1) {
                try {
                    Class<?> enumPlayerInfoActionClass = Class.forName("net.minecraft.network.protocol.game.PacketPlayOutPlayerInfo$EnumPlayerInfoAction");
                    this.removePlayerEnum = ReflectionUtil.getEnum(enumPlayerInfoActionClass, 4);
                    this.addPlayerEnum = ReflectionUtil.getEnum(enumPlayerInfoActionClass, 0);
                }
                catch (Exception e2) {
                    try {
                        this.removePlayerEnum = ReflectionUtil.getEnum(this.playOutPlayerInfo, "Action", "REMOVE_PLAYER");
                        this.addPlayerEnum = ReflectionUtil.getEnum(this.playOutPlayerInfo, "Action", "ADD_PLAYER");
                    }
                    catch (Exception e3) {
                        Class<?> enumPlayerInfoAction = ReflectionUtil.getNMSClass("EnumPlayerInfoAction", null);
                        this.removePlayerEnum = ReflectionUtil.getEnum(enumPlayerInfoAction, "REMOVE_PLAYER");
                        this.addPlayerEnum = ReflectionUtil.getEnum(enumPlayerInfoAction, "ADD_PLAYER");
                    }
                }
            }
            this.getHandleMethod = ReflectionUtil.getBukkitClass("entity.CraftPlayer").getDeclaredMethod("getHandle", new Class[0]);
            Bukkit.getScheduler().runTask((Plugin)plugin, () -> {
                if (plugin.getServer().getPluginManager().isPluginEnabled("ViaBackwards") && ViaWorkaround.isProtocolNewer()) {
                    this.useViabackwards = true;
                    log.debug("Activating ViaBackwards workaround.");
                }
            });
            log.debug("Using SpigotSkinRefresher");
        }
        catch (Exception e) {
            throw new InitializeException(e);
        }
    }

    private void sendPacket(Object playerConnection, Object packet) throws ReflectionException {
        ReflectionUtil.invokeMethod(playerConnection.getClass(), playerConnection, "sendPacket", new Class[]{this.packet}, packet);
    }

    @Override
    public void accept(Player player) {
        try {
            Object pos;
            Object respawn;
            Object worldType;
            Object worldData;
            Object entityPlayer = this.getHandleMethod.invoke((Object)player, new Object[0]);
            Object removePlayer = ReflectionUtil.invokeConstructor(this.playOutPlayerInfo, this.removePlayerEnum, ImmutableList.of((Object)entityPlayer));
            Object addPlayer = ReflectionUtil.invokeConstructor(this.playOutPlayerInfo, this.addPlayerEnum, ImmutableList.of((Object)entityPlayer));
            Object world = ReflectionUtil.invokeMethod(entityPlayer, "getWorld");
            Object difficulty = ReflectionUtil.invokeMethod(world, "getDifficulty");
            try {
                worldData = ReflectionUtil.invokeMethod(world, "getWorldData");
            }
            catch (Exception ignored) {
                worldData = ReflectionUtil.getObject(world, "worldData");
            }
            try {
                worldType = ReflectionUtil.invokeMethod(worldData, "getType");
            }
            catch (Exception ignored) {
                worldType = ReflectionUtil.invokeMethod(worldData, "getGameType");
            }
            Object playerIntManager = ReflectionUtil.getFieldByType(entityPlayer, "PlayerInteractManager");
            Enum enumGamemode = (Enum)ReflectionUtil.invokeMethod(playerIntManager, "getGameMode");
            int gamemodeId = player.getGameMode().getValue();
            int dimension = player.getWorld().getEnvironment().getId();
            try {
                respawn = ReflectionUtil.invokeConstructor(this.playOutRespawn, dimension, difficulty, worldType, enumGamemode);
            }
            catch (Exception ignored) {
                Object worldObject = ReflectionUtil.getFieldByType(entityPlayer, "World");
                Object dimensionManager = this.getDimensionManager(worldObject, dimension);
                try {
                    respawn = ReflectionUtil.invokeConstructor(this.playOutRespawn, dimensionManager, difficulty, worldType, enumGamemode);
                }
                catch (Exception ignored2) {
                    try {
                        respawn = ReflectionUtil.invokeConstructor(this.playOutRespawn, dimensionManager, worldType, enumGamemode);
                    }
                    catch (Exception ignored3) {
                        long seedEncrypted = Hashing.sha256().hashString((CharSequence)String.valueOf(player.getWorld().getSeed()), StandardCharsets.UTF_8).asLong();
                        try {
                            respawn = ReflectionUtil.invokeConstructor(this.playOutRespawn, dimensionManager, seedEncrypted, worldType, enumGamemode);
                        }
                        catch (Exception ignored5) {
                            Object dimensionKey = ReflectionUtil.invokeMethod(worldObject, "getDimensionKey");
                            boolean debug = (Boolean)ReflectionUtil.invokeMethod(worldObject, "isDebugWorld");
                            boolean flat = (Boolean)ReflectionUtil.invokeMethod(worldObject, "isFlatWorld");
                            List<Object> gameModeList = ReflectionUtil.getFieldByTypeList(playerIntManager, "EnumGamemode");
                            Enum enumGamemodePrevious = (Enum)this.getFromListExcluded(gameModeList, enumGamemode);
                            try {
                                Object typeKey = ReflectionUtil.invokeMethod(worldObject, "getTypeKey");
                                respawn = ReflectionUtil.invokeConstructor(this.playOutRespawn, typeKey, dimensionKey, seedEncrypted, enumGamemode, enumGamemodePrevious, debug, flat, true);
                            }
                            catch (Exception ignored6) {
                                respawn = ReflectionUtil.invokeConstructor(this.playOutRespawn, dimensionManager, dimensionKey, seedEncrypted, enumGamemode, enumGamemodePrevious, debug, flat, true);
                            }
                        }
                    }
                }
            }
            Location l = player.getLocation();
            try {
                pos = ReflectionUtil.invokeConstructor(this.playOutPosition, l.getX(), l.getY(), l.getZ(), Float.valueOf(l.getYaw()), Float.valueOf(l.getPitch()), new HashSet(), 0, false);
            }
            catch (Exception e1) {
                try {
                    pos = ReflectionUtil.invokeConstructor(this.playOutPosition, l.getX(), l.getY(), l.getZ(), Float.valueOf(l.getYaw()), Float.valueOf(l.getPitch()), new HashSet(), 0);
                }
                catch (Exception e2) {
                    pos = ReflectionUtil.invokeConstructor(this.playOutPosition, l.getX(), l.getY(), l.getZ(), Float.valueOf(l.getYaw()), Float.valueOf(l.getPitch()), new HashSet());
                }
            }
            Object slot = ReflectionUtil.invokeConstructor(this.playOutHeldItemSlot, player.getInventory().getHeldItemSlot());
            Object playerCon = ReflectionUtil.getFieldByType(entityPlayer, "PlayerConnection");
            this.sendPacket(playerCon, removePlayer);
            this.sendPacket(playerCon, addPlayer);
            boolean sendRespawnPacketDirectly = true;
            if (this.useViabackwards) {
                try {
                    Object worldObject = ReflectionUtil.getFieldByType(entityPlayer, "World");
                    boolean flat = (Boolean)ReflectionUtil.invokeMethod(worldObject, "isFlatWorld");
                    sendRespawnPacketDirectly = ViaWorkaround.sendCustomPacketVia(new ViaPacketData(player, dimension, Hashing.sha256().hashString((CharSequence)String.valueOf(player.getWorld().getSeed()), StandardCharsets.UTF_8).asLong(), Integer.valueOf(gamemodeId).shortValue(), flat));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (sendRespawnPacketDirectly) {
                this.sendPacket(playerCon, respawn);
            }
            ReflectionUtil.invokeMethod(entityPlayer, "updateAbilities");
            this.sendPacket(playerCon, pos);
            this.sendPacket(playerCon, slot);
            ReflectionUtil.invokeMethod(player, "updateScaledHealth");
            player.updateInventory();
            ReflectionUtil.invokeMethod(entityPlayer, "triggerHealthUpdate");
            if (player.isOp()) {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    player.setOp(false);
                    player.setOp(true);
                });
            }
        }
        catch (IllegalAccessException | InvocationTargetException | ReflectionException e) {
            e.printStackTrace();
        }
    }

    private Object getFromListExcluded(List<Object> list, Object ... excluded) {
        for (Object obj : list) {
            if (obj == excluded) continue;
            return obj;
        }
        return null;
    }

    private Object getDimensionManager(Object worldObject, int dimension) throws ReflectionException {
        try {
            return ReflectionUtil.getFieldByType(worldObject, "DimensionManager");
        }
        catch (ReflectionException e) {
            try {
                Class<?> dimensionManagerClass = ReflectionUtil.getNMSClass("DimensionManager", "net.minecraft.world.level.dimension.DimensionManager");
                for (Method m : dimensionManagerClass.getDeclaredMethods()) {
                    if (m.getReturnType() != dimensionManagerClass || m.getParameterCount() != 1 || m.getParameterTypes()[0] != Integer.TYPE) continue;
                    m.setAccessible(true);
                    return m.invoke(null, dimension);
                }
            }
            catch (IllegalAccessException | InvocationTargetException e2) {
                e2.printStackTrace();
            }
            throw new ReflectionException("Could not get DimensionManager from " + worldObject.getClass().getSimpleName());
        }
    }
}

